/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import android.support.v4.util.ArrayMap;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.component.WXComponent;
import java.util.Map;

class UpdateStyleAction
extends TraceableAction
implements DOMAction,
RenderAction {
    private final String mRef;
    private final JSONObject mData;
    private final boolean mIsCausedByPesudo;
    private Spacing mPadding;
    private Spacing mBorder;

    UpdateStyleAction(String ref, JSONObject data) {
        this(ref, data, false);
    }

    UpdateStyleAction(String ref, JSONObject data, boolean byPesudo) {
        this.mRef = ref;
        this.mData = data;
        this.mIsCausedByPesudo = byPesudo;
    }

    @Override
    public void executeDom(DOMActionContext context) {
        if (context.isDestory() || this.mData == null) {
            return;
        }
        WXSDKInstance instance = context.getInstance();
        WXDomObject domObject = context.getDomByRef(this.mRef);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_UPDATESTYLE);
            }
            return;
        }
        this.mPadding = domObject.getPadding();
        this.mBorder = domObject.getBorder();
        ArrayMap animationMap = new ArrayMap(2);
        animationMap.put("transform", this.mData.get((Object)"transform"));
        animationMap.put("transformOrigin", this.mData.get((Object)"transformOrigin"));
        context.addAnimationForElement(this.mRef, (Map<String, Object>)animationMap);
        if (!this.mData.isEmpty()) {
            domObject.updateStyle((Map<String, Object>)this.mData, this.mIsCausedByPesudo);
            domObject.traverseTree(context.getApplyStyleConsumer());
            context.postRenderTask(this);
        }
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent component = context.getComponent(this.mRef);
        if (component == null) {
            return;
        }
        component.updateProperties((Map<String, Object>)this.mData);
        if (this.mData.containsKey((Object)"padding") || this.mData.containsKey((Object)"paddingTop") || this.mData.containsKey((Object)"paddingLeft") || this.mData.containsKey((Object)"paddingRight") || this.mData.containsKey((Object)"paddingBottom") || this.mData.containsKey((Object)"borderWidth")) {
            Spacing padding = this.mPadding;
            Spacing border = this.mBorder;
            component.setPadding(padding, border);
        }
    }
}

