/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;

public class TraceableAction {
    public int mTracingEventId;
    public long mStartMillis;
    public long mDomQueueTime;
    public long mUIQueueTime;
    public long mParseJsonNanos = -1L;
    protected WXTracing.TraceEvent mBeginEvent;

    public TraceableAction() {
        if (WXTracing.isAvailable()) {
            this.mTracingEventId = WXTracing.nextId();
            this.mStartMillis = System.currentTimeMillis();
        }
    }

    protected WXTracing.TraceEvent submitPerformance(String fname, String ph, String instanceId, double duration, long ts, boolean ... isSegment) {
        if (WXTracing.isAvailable()) {
            WXTracing.TraceEvent event = WXTracing.newEvent(fname, instanceId, this.mTracingEventId);
            event.ts = ts;
            event.ph = ph;
            event.duration = duration;
            if (isSegment != null && isSegment.length == 1) {
                event.isSegment = isSegment[0];
            }
            event.submit();
            return event;
        }
        return new WXTracing.TraceEvent();
    }

    public void onStartDomExecute(String instanceId, String fname, String ref, String type, String payload) {
        if (WXTracing.isAvailable()) {
            this.mBeginEvent = WXTracing.newEvent(fname, instanceId, -1);
            this.mBeginEvent.traceId = this.mTracingEventId;
            this.mBeginEvent.ts = this.mStartMillis;
            this.mBeginEvent.ph = "B";
            this.mBeginEvent.ref = ref;
            this.mBeginEvent.name = type;
            this.mBeginEvent.payload = payload;
            this.mBeginEvent.parseJsonTime = Stopwatch.nanosToMillis(this.mParseJsonNanos);
            this.mBeginEvent.tname = "JSThread";
            this.mBeginEvent.submit();
        }
    }

    public void onFinishUIExecute() {
        if (WXTracing.isAvailable() && this.mBeginEvent != null) {
            WXTracing.TraceEvent endEvent = WXTracing.newEvent(this.getClass().getSimpleName(), this.mBeginEvent.iid, -1);
            endEvent.traceId = this.mBeginEvent.traceId;
            endEvent.ph = "E";
            endEvent.submit();
        }
    }
}

