/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.DOMActionContextImpl;
import com.taobao.weex.dom.WXDomHandler;
import com.taobao.weex.dom.WXDomTask;
import com.taobao.weex.dom.action.AbstractAddElementAction;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class WXDomManager {
    private WXThread mDomThread;
    Handler mDomHandler;
    private WXRenderManager mWXRenderManager;
    private ConcurrentHashMap<String, DOMActionContextImpl> mDomRegistries;

    public WXDomManager(WXRenderManager renderManager) {
        this.mWXRenderManager = renderManager;
        this.mDomRegistries = new ConcurrentHashMap();
        this.mDomThread = new WXThread("WeeXDomThread", new WXDomHandler(this));
        this.mDomHandler = this.mDomThread.getHandler();
    }

    public void sendEmptyMessageDelayed(int what, long delayMillis) {
        if (this.mDomHandler == null || this.mDomThread == null || !this.mDomThread.isWXThreadAlive() || this.mDomThread.getLooper() == null) {
            return;
        }
        this.mDomHandler.sendEmptyMessageDelayed(what, delayMillis);
    }

    public void sendMessage(Message msg) {
        this.sendMessageDelayed(msg, 0L);
    }

    public void sendMessageDelayed(Message msg, long delay) {
        if (msg == null || this.mDomHandler == null || this.mDomThread == null || !this.mDomThread.isWXThreadAlive() || this.mDomThread.getLooper() == null) {
            return;
        }
        this.mDomHandler.sendMessageDelayed(msg, delay);
    }

    public void removeDomStatement(String instanceId) {
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXDomManager] removeDomStatement");
        }
        final DOMActionContextImpl statement = this.mDomRegistries.remove(instanceId);
        if (statement != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    statement.destroy();
                }
            });
        }
    }

    public void post(Runnable task) {
        if (this.mDomHandler == null || task == null || this.mDomThread == null || !this.mDomThread.isWXThreadAlive() || this.mDomThread.getLooper() == null) {
            return;
        }
        this.mDomHandler.post(WXThread.secure(task));
    }

    public void destroy() {
        if (this.mDomThread != null && this.mDomThread.isWXThreadAlive()) {
            this.mDomThread.quit();
        }
        if (this.mDomRegistries != null) {
            this.mDomRegistries.clear();
        }
        this.mDomHandler = null;
        this.mDomThread = null;
    }

    private boolean isDomThread() {
        return !WXEnvironment.isApkDebugable() || Thread.currentThread().getId() == this.mDomThread.getId();
    }

    void batch() {
        this.throwIfNotDomThread();
        Iterator<Map.Entry<String, DOMActionContextImpl>> iterator = this.mDomRegistries.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().batch();
        }
    }

    void consumeRenderTask(String instanceId) {
        this.throwIfNotDomThread();
        DOMActionContextImpl context = this.mDomRegistries.get(instanceId);
        if (context != null) {
            context.consumeRenderTasks();
        }
    }

    private void throwIfNotDomThread() {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("dom operation must be done in dom thread");
        }
    }

    public void executeAction(String instanceId, DOMAction action, boolean createContext) {
        DOMActionContext context = this.mDomRegistries.get(instanceId);
        if (context == null) {
            if (createContext) {
                DOMActionContextImpl oldStatement = new DOMActionContextImpl(instanceId, this.mWXRenderManager);
                this.mDomRegistries.put(instanceId, oldStatement);
                context = oldStatement;
            } else {
                return;
            }
        }
        long domStart = System.currentTimeMillis();
        long domNanos = System.nanoTime();
        action.executeDom(context);
        if (WXTracing.isAvailable()) {
            domNanos = System.nanoTime() - domNanos;
            if (!(action instanceof AbstractAddElementAction) && action instanceof TraceableAction) {
                WXTracing.TraceEvent domExecuteEvent = WXTracing.newEvent("DomExecute", context.getInstanceId(), ((TraceableAction)((Object)action)).mTracingEventId);
                domExecuteEvent.duration = Stopwatch.nanosToMillis(domNanos);
                domExecuteEvent.ts = domStart;
                domExecuteEvent.submit();
            }
        }
    }

    public void postAction(String instanceId, DOMAction action, boolean createContext) {
        this.postActionDelay(instanceId, action, createContext, 0L);
    }

    public void postActionDelay(String instanceId, DOMAction action, boolean createContext, long delay) {
        if (action == null) {
            return;
        }
        Message msg = Message.obtain();
        msg.what = 254;
        WXDomTask task = new WXDomTask();
        task.instanceId = instanceId;
        task.args = new ArrayList<Object>();
        task.args.add(action);
        task.args.add(createContext);
        msg.obj = task;
        this.sendMessageDelayed(msg, delay);
    }

    public void postRenderTask(@NonNull String instanceId) {
        Message msg = Message.obtain();
        msg.what = 250;
        WXDomTask task = new WXDomTask();
        task.instanceId = instanceId;
        msg.obj = task;
        this.sendMessage(msg);
    }
}

