/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.websocket;

import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.appfram.websocket.WebSocketCloseCodes;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;

public class WebSocketModule
extends WXSDKEngine.DestroyableModule {
    private static final String TAG = "WebSocketModule";
    private static final String KEY_DATA = "data";
    private static final String KEY_CODE = "code";
    private static final String KEY_REASON = "reason";
    private static final String KEY_WAS_CLEAN = "wasClean";
    private IWebSocketAdapter webSocketAdapter;
    private JSCallback onOpen;
    private JSCallback onMessage;
    private JSCallback onClose;
    private JSCallback onError;
    private IWebSocketAdapter.EventListener eventListener = new IWebSocketAdapter.EventListener(){

        @Override
        public void onOpen() {
            if (WebSocketModule.this.onOpen != null) {
                WebSocketModule.this.onOpen.invoke(new HashMap(0));
            }
        }

        @Override
        public void onMessage(String data) {
            if (WebSocketModule.this.onMessage != null) {
                HashMap<String, String> msg = new HashMap<String, String>(1);
                msg.put(WebSocketModule.KEY_DATA, data);
                WebSocketModule.this.onMessage.invokeAndKeepAlive(msg);
            }
        }

        @Override
        public void onClose(int code, String reason, boolean wasClean) {
            if (WebSocketModule.this.onClose != null) {
                HashMap<String, Object> msg = new HashMap<String, Object>(3);
                msg.put(WebSocketModule.KEY_CODE, code);
                msg.put(WebSocketModule.KEY_REASON, reason);
                msg.put(WebSocketModule.KEY_WAS_CLEAN, wasClean);
                WebSocketModule.this.onClose.invoke(msg);
            }
        }

        @Override
        public void onError(String msg) {
            if (WebSocketModule.this.onError != null) {
                HashMap<String, String> info = new HashMap<String, String>(1);
                info.put(WebSocketModule.KEY_DATA, msg);
                WebSocketModule.this.onError.invokeAndKeepAlive(info);
            }
        }
    };

    @JSMethod
    public void WebSocket(String url, String protocol) {
        if (this.webSocketAdapter != null) {
            this.webSocketAdapter.close(WebSocketCloseCodes.CLOSE_GOING_AWAY.getCode(), WebSocketCloseCodes.CLOSE_GOING_AWAY.name());
        }
        this.webSocketAdapter = this.mWXSDKInstance.getWXWebSocketAdapter();
        if (!this.reportErrorIfNoAdapter()) {
            this.webSocketAdapter.connect(url, protocol, this.eventListener);
        }
    }

    @JSMethod
    public void send(String data) {
        if (!this.reportErrorIfNoAdapter()) {
            this.webSocketAdapter.send(data);
        }
    }

    @JSMethod
    public void close(String code, String reason) {
        if (!this.reportErrorIfNoAdapter()) {
            int codeNumber = WebSocketCloseCodes.CLOSE_NORMAL.getCode();
            if (code != null) {
                try {
                    codeNumber = Integer.parseInt(code);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.webSocketAdapter.close(codeNumber, reason);
        }
    }

    @JSMethod
    public void onopen(JSCallback callback) {
        this.onOpen = callback;
    }

    @JSMethod
    public void onmessage(JSCallback callback) {
        this.onMessage = callback;
    }

    @JSMethod
    public void onclose(JSCallback callback) {
        this.onClose = callback;
    }

    @JSMethod
    public void onerror(JSCallback callback) {
        this.onError = callback;
    }

    @Override
    public void destroy() {
        if (this.webSocketAdapter != null) {
            this.webSocketAdapter.destroy();
        }
        this.eventListener = null;
    }

    private boolean reportErrorIfNoAdapter() {
        if (this.webSocketAdapter == null) {
            if (this.eventListener != null) {
                this.eventListener.onError("No implementation found for IWebSocketAdapter");
            }
            WXLogUtils.e(TAG, "No implementation found for IWebSocketAdapter");
            return true;
        }
        return false;
    }
}

