/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.taobao.weex.ui.view.border.BorderCorner;

class BorderEdge {
    @NonNull
    private final BorderCorner mPreCorner;
    @NonNull
    private final BorderCorner mPostCorner;
    private final int mEdge;
    private final float mBorderWidth;

    BorderEdge(@NonNull BorderCorner preCorner, @NonNull BorderCorner postCorner, int edge, float borderWidth) {
        this.mPreCorner = preCorner;
        this.mPostCorner = postCorner;
        this.mEdge = edge;
        this.mBorderWidth = borderWidth;
    }

    void drawEdge(@NonNull Canvas canvas, @NonNull Paint paint) {
        PointF lineStart = this.mPreCorner.getCornerEnd();
        paint.setStrokeWidth(this.mBorderWidth);
        this.drawRoundedCorner(canvas, paint, this.mPreCorner, this.mPreCorner.getAngleBisectorDegree(), this.mPreCorner.getSharpCornerStart(), lineStart);
        paint.setStrokeWidth(this.mBorderWidth);
        PointF lineEnd = this.mPostCorner.getCornerStart();
        canvas.drawLine(lineStart.x, lineStart.y, lineEnd.x, lineEnd.y, paint);
        this.drawRoundedCorner(canvas, paint, this.mPostCorner, this.mPostCorner.getAngleBisectorDegree() - 45.0f, lineEnd, this.mPostCorner.getSharpCornerEnd());
    }

    private void drawRoundedCorner(@NonNull Canvas canvas, @NonNull Paint paint, @NonNull BorderCorner borderCorner, float startAngle, @NonNull PointF startPoint, @NonNull PointF endPoint) {
        if (borderCorner.hasOuterCorner()) {
            RectF oval;
            if (borderCorner.hasInnerCorner()) {
                oval = borderCorner.getOvalIfInnerCornerExist();
            } else {
                paint.setStrokeWidth(borderCorner.getOuterCornerRadius());
                oval = borderCorner.getOvalIfInnerCornerNotExist();
            }
            canvas.drawArc(oval, startAngle, 45.0f, false, paint);
        } else {
            canvas.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y, paint);
        }
    }

    public int getEdge() {
        return this.mEdge;
    }
}

