/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.module;

import android.os.Handler;
import android.os.Message;
import android.support.annotation.IntRange;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXHashMap;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class WXTimerModule
extends WXModule
implements Destroyable,
Handler.Callback {
    private static final String TAG = "timer";
    private Handler handler = new Handler(WXBridgeManager.getInstance().getJSLooper(), (Handler.Callback)this);

    void setHandler(Handler handler) {
        this.handler = handler;
    }

    @JSMethod(uiThread=false)
    public void setTimeout(@IntRange(from=1L) int funcId, @IntRange(from=0L) int delay) {
        this.postMessage(11, funcId, delay, Integer.parseInt(this.mWXSDKInstance.getInstanceId()));
    }

    @JSMethod(uiThread=false)
    public void setInterval(@IntRange(from=1L) int funcId, @IntRange(from=0L) int interval) {
        this.postMessage(12, funcId, interval, Integer.parseInt(this.mWXSDKInstance.getInstanceId()));
    }

    @JSMethod(uiThread=false)
    public void clearTimeout(@IntRange(from=1L) int funcId) {
        if (funcId <= 0) {
            return;
        }
        this.handler.removeMessages(11, (Object)funcId);
    }

    @JSMethod(uiThread=false)
    public void clearInterval(@IntRange(from=1L) int funcId) {
        if (funcId <= 0) {
            return;
        }
        this.handler.removeMessages(12, (Object)funcId);
    }

    @Override
    public void destroy() {
        if (this.handler != null) {
            WXLogUtils.d(TAG, "Timer Module removeAllMessages: ");
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    public boolean handleMessage(Message msg) {
        boolean ret = false;
        if (msg != null) {
            int what = msg.what;
            WXLogUtils.d(TAG, "Timer Module handleMessage : " + msg.what);
            switch (what) {
                case 11: {
                    if (msg.obj == null) break;
                    WXJSObject[] args = this.createTimerArgs(msg.arg1, (Integer)msg.obj, false);
                    WXBridgeManager.getInstance().invokeExecJS(String.valueOf(msg.arg1), null, "callJS", args, true);
                    ret = true;
                    break;
                }
                case 12: {
                    if (msg.obj == null) break;
                    this.postMessage(12, (Integer)msg.obj, msg.arg2, msg.arg1);
                    WXJSObject[] args = this.createTimerArgs(msg.arg1, (Integer)msg.obj, true);
                    WXBridgeManager.getInstance().invokeExecJS(String.valueOf(msg.arg1), null, "callJS", args, true);
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    private WXJSObject[] createTimerArgs(int instanceId, int funcId, boolean keepAlive) {
        ArrayList<Serializable> argsList = new ArrayList<Serializable>();
        argsList.add(Integer.valueOf(funcId));
        argsList.add(new HashMap());
        argsList.add(Boolean.valueOf(keepAlive));
        WXHashMap<String, Object> task = new WXHashMap<String, Object>();
        task.put("method", "callback");
        task.put("args", argsList);
        Object[] tasks = new Object[]{task};
        return new WXJSObject[]{new WXJSObject(2, String.valueOf(instanceId)), new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(tasks))};
    }

    private void postMessage(int what, @IntRange(from=1L) int funcId, @IntRange(from=0L) int interval, int instanceId) {
        if (interval < 0 || funcId <= 0) {
            WXLogUtils.e(TAG, "interval < 0 or funcId <=0");
        } else {
            Message message = Message.obtain();
            message.what = what;
            message.arg1 = instanceId;
            message.arg2 = interval;
            message.obj = funcId;
            this.handler.sendMessageDelayed(message, (long)interval);
        }
    }
}

