/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StickyHeaderHelper {
    private final ViewGroup mParent;
    private Map<String, View> mHeaderViews = new HashMap<String, View>();
    private Map<String, WXCell> mHeaderComps = new HashMap<String, WXCell>();
    private String mCurrentStickyRef = null;

    public StickyHeaderHelper(ViewGroup parent) {
        this.mParent = parent;
    }

    public void notifyStickyShow(WXCell component) {
        if (component == null) {
            return;
        }
        this.mHeaderComps.put(component.getRef(), component);
        if (this.mCurrentStickyRef != null) {
            WXCell cell = this.mHeaderComps.get(this.mCurrentStickyRef);
            if (component.getScrollPositon() > cell.getScrollPositon()) {
                this.mCurrentStickyRef = component.getRef();
            }
        } else {
            this.mCurrentStickyRef = component.getRef();
        }
        this.showSticky();
    }

    private void showSticky() {
        if (this.mCurrentStickyRef == null) {
            WXLogUtils.e("Current Sticky ref is null.");
            return;
        }
        WXCell headComponent = this.mHeaderComps.get(this.mCurrentStickyRef);
        ViewGroup headerView = headComponent.getRealView();
        if (headerView == null) {
            WXLogUtils.e("Sticky header's real view is null.");
            return;
        }
        View header = this.mHeaderViews.get(headComponent.getRef());
        if (header != null) {
            header.bringToFront();
        } else {
            this.mHeaderViews.put(headComponent.getRef(), (View)headerView);
            float translationX = headerView.getTranslationX();
            float translationY = headerView.getTranslationY();
            headComponent.removeSticky();
            this.mParent.post(WXThread.secure(new Runnable((View)headerView, translationX, translationY){
                final /* synthetic */ View val$headerView;
                final /* synthetic */ float val$translationX;
                final /* synthetic */ float val$translationY;
                {
                    this.val$headerView = view;
                    this.val$translationX = f;
                    this.val$translationY = f2;
                }

                @Override
                public void run() {
                    ViewGroup existedParent = (ViewGroup)this.val$headerView.getParent();
                    if (existedParent != null) {
                        existedParent.removeView(this.val$headerView);
                    }
                    StickyHeaderHelper.this.mParent.addView(this.val$headerView);
                    this.val$headerView.setTranslationX(this.val$translationX);
                    this.val$headerView.setTranslationY(this.val$translationY);
                }
            }));
        }
    }

    public void notifyStickyRemove(WXCell compToRemove) {
        if (compToRemove == null) {
            return;
        }
        final WXCell component = this.mHeaderComps.remove(compToRemove.getRef());
        final View headerView = this.mHeaderViews.remove(compToRemove.getRef());
        if (component == null || headerView == null) {
            WXLogUtils.e(" sticky header to remove not found." + compToRemove.getRef());
            return;
        }
        if (this.mCurrentStickyRef != null && this.mCurrentStickyRef.equals(compToRemove.getRef())) {
            this.mCurrentStickyRef = null;
        }
        this.mParent.post(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                StickyHeaderHelper.this.mParent.removeView(headerView);
                component.recoverySticky();
            }
        }));
    }

    public void updateStickyView(int currentStickyPos) {
        Iterator<Map.Entry<String, WXCell>> iterator = this.mHeaderComps.entrySet().iterator();
        ArrayList<WXCell> toRemove = new ArrayList<WXCell>();
        while (iterator.hasNext()) {
            Map.Entry<String, WXCell> next = iterator.next();
            WXCell cell = next.getValue();
            int pos = cell.getScrollPositon();
            if (pos > currentStickyPos) {
                toRemove.add(cell);
                continue;
            }
            if (pos != currentStickyPos) continue;
            this.mCurrentStickyRef = cell.getRef();
            View view = this.mHeaderViews.get(cell.getRef());
            if (view == null) continue;
            view.bringToFront();
        }
        for (WXCell cell : toRemove) {
            this.notifyStickyRemove(cell);
        }
    }
}

