/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Intent;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import java.util.ArrayList;

public abstract class WXVContainer<T extends ViewGroup>
extends WXComponent<T> {
    private static final String TAG = "WXVContainer";
    protected ArrayList<WXComponent> mChildren = new ArrayList();

    @Deprecated
    public WXVContainer(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    @Deprecated
    public WXVContainer(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent);
    }

    public WXVContainer(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    public void interceptFocus() {
        ViewGroup host = (ViewGroup)this.getHostView();
        if (host != null) {
            host.setFocusable(true);
            host.setFocusableInTouchMode(true);
            host.setDescendantFocusability(131072);
            host.requestFocus();
        }
    }

    public void ignoreFocus() {
        ViewGroup host = (ViewGroup)this.getHostView();
        if (host != null) {
            host.setFocusable(false);
            host.setFocusableInTouchMode(false);
            host.clearFocus();
        }
    }

    protected int getChildrenLayoutTopOffset() {
        return 0;
    }

    @Deprecated
    public ViewGroup getView() {
        return (ViewGroup)this.getHostView();
    }

    @Override
    public void applyLayoutAndEvent(WXComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            super.applyLayoutAndEvent(component);
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                WXComponent child = this.getChild(i);
                child.applyLayoutAndEvent(((WXVContainer)component).getChild(i));
            }
        }
    }

    public ViewGroup.LayoutParams getChildLayoutParams(WXComponent child, View childView, int width, int height, int left, int right, int top, int bottom) {
        ViewGroup.LayoutParams lp = childView.getLayoutParams();
        if (lp == null) {
            lp = new ViewGroup.LayoutParams(width, height);
        } else {
            lp.width = width;
            lp.height = height;
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams)lp).setMargins(left, top, right, bottom);
            }
        }
        return lp;
    }

    @Override
    public void bindData(WXComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            super.bindData(component);
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                this.getChild(i).bindData(((WXVContainer)component).getChild(i));
            }
        }
    }

    @Override
    public void refreshData(WXComponent component) {
        if (component == null) {
            component = this;
        }
        super.refreshData(component);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).refreshData(((WXVContainer)component).getChild(i));
        }
    }

    public ViewGroup getRealView() {
        return (ViewGroup)super.getRealView();
    }

    @Override
    public void createViewImpl() {
        super.createViewImpl();
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.createChildViewAt(i);
        }
        if (this.getHostView() != null) {
            ((ViewGroup)this.getHostView()).setClipToPadding(false);
        }
    }

    @Override
    public void destroy() {
        if (this.mChildren != null) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                this.mChildren.get(i).destroy();
            }
            this.mChildren.clear();
        }
        super.destroy();
    }

    @Override
    public void recycled() {
        if (this.mChildren != null && !this.getDomObject().isFixed() && this.getDomObject().getAttrs().canRecycled()) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                this.mChildren.get(i).recycled();
            }
        }
        super.recycled();
    }

    @Override
    public View detachViewAndClearPreInfo() {
        View original = super.detachViewAndClearPreInfo();
        if (this.mChildren != null) {
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                this.mChildren.get(i).detachViewAndClearPreInfo();
            }
        }
        return original;
    }

    public int childCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    public WXComponent getChild(int index) {
        return this.mChildren.get(index);
    }

    public int getChildCount() {
        return this.mChildren.size();
    }

    public void addChild(WXComponent child) {
        this.addChild(child, -1);
    }

    public void addChild(WXComponent child, int index) {
        if (child == null || index < -1) {
            return;
        }
        int count = this.mChildren.size();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.mChildren.add(child);
        } else {
            this.mChildren.add(index, child);
        }
    }

    public final int indexOf(WXComponent comp) {
        return this.mChildren.indexOf(comp);
    }

    public void createChildViewAt(int index) {
        int indexToCreate = index;
        if (indexToCreate < 0 && (indexToCreate = this.childCount() - 1) < 0) {
            return;
        }
        WXComponent child = this.getChild(indexToCreate);
        child.createView();
        if (!child.isVirtualComponent()) {
            this.addSubView((View)child.getHostView(), indexToCreate);
        }
    }

    protected void addSubView(View child, int index) {
        if (child == null || this.getRealView() == null) {
            return;
        }
        int count = this.getRealView().getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.getRealView().addView(child);
        } else {
            this.getRealView().addView(child, index);
        }
    }

    public void remove(WXComponent child, boolean destroy) {
        if (child == null || this.mChildren == null || this.mChildren.size() == 0) {
            return;
        }
        this.mChildren.remove(child);
        if (this.getInstance() != null && this.getInstance().getRootView() != null && child.getDomObject().isFixed()) {
            this.getInstance().removeFixedView((View)child.getHostView());
        } else if (this.getRealView() != null) {
            if (!child.isVirtualComponent()) {
                this.getRealView().removeView(child.getHostView());
            } else {
                child.removeVirtualComponent();
            }
        }
        if (destroy) {
            child.destroy();
        }
    }

    @Override
    public void notifyAppearStateChange(String wxEventType, String direction) {
        super.notifyAppearStateChange(wxEventType, direction);
        if (this.getHostView() == null || this.mChildren == null) {
            return;
        }
        for (WXComponent component : this.mChildren) {
            if (component.getHostView() != null && component.getHostView().getVisibility() != 0) {
                wxEventType = "disappear";
            }
            component.notifyAppearStateChange(wxEventType, direction);
        }
    }

    @Override
    public void onActivityCreate() {
        super.onActivityCreate();
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onActivityCreate();
        }
    }

    @Override
    public void onActivityStart() {
        super.onActivityStart();
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onActivityStart();
        }
    }

    @Override
    public void onActivityPause() {
        super.onActivityPause();
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onActivityPause();
        }
    }

    @Override
    public void onActivityResume() {
        super.onActivityResume();
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onActivityResume();
        }
    }

    @Override
    public void onActivityStop() {
        super.onActivityStop();
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onActivityStop();
        }
    }

    @Override
    public void onActivityDestroy() {
        super.onActivityDestroy();
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onActivityDestroy();
        }
    }

    @Override
    public boolean onActivityBack() {
        super.onActivityBack();
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onActivityBack();
        }
        return false;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onCreateOptionsMenu(menu);
        }
        return false;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }
}

