/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.wrapper;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.ListComponentView;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import java.util.Stack;

public class BounceRecyclerView
extends BaseBounceView<WXRecyclerView>
implements ListComponentView,
WXGestureObservable {
    private RecyclerViewBaseAdapter adapter = null;
    private Stack<View> headerViewStack = new Stack();
    private Stack<WXCell> headComponentStack = new Stack();
    private WXGesture mGesture;

    public boolean postDelayed(Runnable action, long delayMillis) {
        return super.postDelayed(WXThread.secure(action), delayMillis);
    }

    public BounceRecyclerView(Context context, int orientation) {
        super(context, orientation);
    }

    public BounceRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs, 1);
    }

    @Override
    public void setRecyclerViewBaseAdapter(RecyclerViewBaseAdapter adapter) {
        this.adapter = adapter;
        if (this.getInnerView() != null) {
            ((WXRecyclerView)this.getInnerView()).setAdapter(adapter);
        }
    }

    @Override
    public RecyclerViewBaseAdapter getRecyclerViewBaseAdapter() {
        return this.adapter;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.mGesture != null) {
            result |= this.mGesture.onTouch((View)this, event);
        }
        return result;
    }

    @Override
    public WXRecyclerView setInnerView(Context context) {
        WXRecyclerView wxRecyclerView = new WXRecyclerView(context);
        wxRecyclerView.initView(context, 1, this.getOrientation());
        return wxRecyclerView;
    }

    @Override
    public void onRefreshingComplete() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onLoadmoreComplete() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyStickyShow(WXCell component) {
        if (component == null) {
            return;
        }
        if (this.headComponentStack.isEmpty()) {
            this.headComponentStack.push(component);
            this.showSticky();
            return;
        }
        WXCell oldCom = this.headComponentStack.pop();
        if (!oldCom.getRef().equals(component.getRef())) {
            this.headComponentStack.push(oldCom);
            this.headComponentStack.push(component);
            this.showSticky();
            return;
        }
        this.headComponentStack.push(oldCom);
    }

    @Override
    public void notifyStickyRemove(WXCell component) {
        if (component == null) {
            return;
        }
        if (!this.headComponentStack.isEmpty() && !this.headerViewStack.isEmpty()) {
            this.removeSticky(component);
        }
    }

    private void showSticky() {
        WXCell headComponent = this.headComponentStack.pop();
        this.headComponentStack.push(headComponent);
        ViewGroup headerView = headComponent.getRealView();
        if (headerView == null) {
            return;
        }
        this.headerViewStack.push((View)headerView);
        float translationX = headerView.getTranslationX();
        float translationY = headerView.getTranslationY();
        headComponent.removeSticky();
        this.post(WXThread.secure(new Runnable((View)headerView, translationX, translationY){
            final /* synthetic */ View val$headerView;
            final /* synthetic */ float val$translationX;
            final /* synthetic */ float val$translationY;
            {
                this.val$headerView = view;
                this.val$translationX = f;
                this.val$translationY = f2;
            }

            @Override
            public void run() {
                ViewGroup existedParent = (ViewGroup)this.val$headerView.getParent();
                if (existedParent != null) {
                    existedParent.removeView(this.val$headerView);
                }
                BounceRecyclerView.this.addView(this.val$headerView);
                this.val$headerView.setTranslationX(this.val$translationX);
                this.val$headerView.setTranslationY(this.val$translationY);
            }
        }));
    }

    private void removeSticky(WXComponent component) {
        final WXCell headComponent = this.headComponentStack.pop();
        if (!component.getRef().equals(headComponent.getRef())) {
            this.headComponentStack.push(headComponent);
            return;
        }
        final View headerView = this.headerViewStack.pop();
        this.post(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                BounceRecyclerView.this.removeView(headerView);
                headComponent.recoverySticky();
            }
        }));
    }

    public void clearSticky() {
        int size = this.headComponentStack.size();
        while (size > 0 && this.headerViewStack.size() == size) {
            WXCell headComponent = this.headComponentStack.pop();
            View headerView = this.headerViewStack.pop();
            ((ViewGroup)this.getParent()).removeView(headerView);
            headComponent.recoverySticky();
        }
    }

    @Override
    public void registerGestureListener(@Nullable WXGesture wxGesture) {
        this.mGesture = wxGesture;
        ((WXRecyclerView)this.getInnerView()).registerGestureListener(wxGesture);
    }
}

