/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.MotionEvent;
import android.view.View;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;

public class WXRecyclerView
extends RecyclerView
implements WXGestureObservable {
    public static final int TYPE_LINEAR_LAYOUT = 1;
    public static final int TYPE_GRID_LAYOUT = 2;
    public static final int TYPE_STAGGERED_GRID_LAYOUT = 3;
    private WXGesture mGesture;
    private boolean scrollable = true;

    public WXRecyclerView(Context context) {
        super(context);
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public boolean postDelayed(Runnable action, long delayMillis) {
        return super.postDelayed(WXThread.secure(action), delayMillis);
    }

    public void initView(Context context, int type, int orientation) {
        if (type == 2) {
            this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, 2, orientation, false));
        } else if (type == 3) {
            this.setLayoutManager((RecyclerView.LayoutManager)new StaggeredGridLayoutManager(2, orientation));
        } else if (type == 1) {
            this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, orientation, false){

                public boolean supportsPredictiveItemAnimations() {
                    return false;
                }

                public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
                    try {
                        super.onLayoutChildren(recycler, state);
                    }
                    catch (IndexOutOfBoundsException e) {
                        e.printStackTrace();
                    }
                }

                public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
                    try {
                        return super.scrollVerticallyBy(dy, recycler, state);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 0;
                    }
                }
            });
        }
    }

    @Override
    public void registerGestureListener(@Nullable WXGesture wxGesture) {
        this.mGesture = wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.scrollable) {
            return true;
        }
        boolean result = super.onTouchEvent(event);
        if (this.mGesture != null) {
            result |= this.mGesture.onTouch((View)this, event);
        }
        return result;
    }
}

