/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import com.taobao.weex.ui.view.border.BorderCorner;

class BorderEdge {
    @NonNull
    private final BorderCorner mPreCorner;
    @NonNull
    private final BorderCorner mPostCorner;
    private final int mEdge;
    private final float mBorderWidth;

    BorderEdge(@NonNull BorderCorner preCorner, @NonNull BorderCorner postCorner, int edge, float borderWidth) {
        this.mPreCorner = preCorner;
        this.mPostCorner = postCorner;
        this.mEdge = edge;
        this.mBorderWidth = borderWidth;
    }

    void drawEdge(@NonNull Canvas canvas, @NonNull Paint paint) {
        Path path;
        PointF lineStart = this.mPreCorner.getCornerEnd();
        if (this.mPreCorner.hasOuterCorner()) {
            path = new Path();
            if (this.mPreCorner.hasInnerCorner()) {
                path.addArc(this.mPreCorner.getOvalIfInnerCornerExist(), this.mPreCorner.getAngleBisectorDegree(), 45.0f);
            } else {
                paint.setStrokeWidth(this.mPreCorner.getOuterCornerRadius());
                path.addArc(this.mPreCorner.getOvalIfInnerCornerNotExist(), this.mPreCorner.getAngleBisectorDegree(), 45.0f);
            }
            canvas.drawPath(path, paint);
        } else {
            PointF actualStart = this.mPreCorner.getSharpCornerStart();
            canvas.drawLine(actualStart.x, actualStart.y, lineStart.x, lineStart.y, paint);
        }
        paint.setStrokeWidth(this.mBorderWidth);
        PointF lineEnd = this.mPostCorner.getCornerStart();
        canvas.drawLine(lineStart.x, lineStart.y, lineEnd.x, lineEnd.y, paint);
        if (this.mPostCorner.hasOuterCorner()) {
            path = new Path();
            if (this.mPostCorner.hasInnerCorner()) {
                path.addArc(this.mPostCorner.getOvalIfInnerCornerExist(), this.mPostCorner.getAngleBisectorDegree() - 45.0f, 45.0f);
            } else {
                paint.setStrokeWidth(this.mPostCorner.getOuterCornerRadius());
                path.addArc(this.mPostCorner.getOvalIfInnerCornerNotExist(), this.mPostCorner.getAngleBisectorDegree() - 45.0f, 45.0f);
            }
            canvas.drawPath(path, paint);
        } else {
            PointF actualEnd = this.mPostCorner.getSharpCornerEnd();
            canvas.drawLine(lineEnd.x, lineEnd.y, actualEnd.x, actualEnd.y, paint);
        }
    }

    public int getEdge() {
        return this.mEdge;
    }
}

