/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.animation;

import android.animation.IntEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import android.view.View;
import android.view.ViewGroup;

public class DimensionUpdateListener
implements ValueAnimator.AnimatorUpdateListener {
    private View view;
    private Pair<Integer, Integer> width;
    private Pair<Integer, Integer> height;
    private IntEvaluator intEvaluator;

    DimensionUpdateListener(@NonNull View view) {
        this.view = view;
        this.intEvaluator = new IntEvaluator();
    }

    void setWidth(int from, int to) {
        this.width = new Pair((Object)from, (Object)to);
    }

    void setHeight(int from, int to) {
        this.height = new Pair((Object)from, (Object)to);
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        if (this.view.getLayoutParams() != null) {
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            TimeInterpolator interpolator = animation.getInterpolator();
            float fraction = animation.getAnimatedFraction();
            int preWidth = layoutParams.width;
            int preHeight = layoutParams.height;
            if (this.width != null) {
                layoutParams.width = this.intEvaluator.evaluate(interpolator.getInterpolation(fraction), (Integer)this.width.first, (Integer)this.width.second);
            }
            if (this.height != null) {
                layoutParams.height = this.intEvaluator.evaluate(interpolator.getInterpolation(fraction), (Integer)this.height.first, (Integer)this.height.second);
            }
            if (preHeight != layoutParams.height || preWidth != layoutParams.width) {
                this.view.requestLayout();
            }
        }
    }
}

