/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXCustomStyleSpan;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXLineHeightSpan;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSConstants;
import com.taobao.weex.dom.flex.CSSNode;
import com.taobao.weex.dom.flex.FloatUtil;
import com.taobao.weex.dom.flex.MeasureOutput;
import com.taobao.weex.ui.component.WXTextDecoration;
import com.taobao.weex.utils.WXDomUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class WXTextDomObject
extends WXDomObject {
    static final CSSNode.MeasureFunction TEXT_MEASURE_FUNCTION = new CSSNode.MeasureFunction(){

        @Override
        public void measure(CSSNode node, float width, @NonNull MeasureOutput measureOutput) {
            WXTextDomObject textDomObject = (WXTextDomObject)node;
            if (CSSConstants.isUndefined(width)) {
                width = node.cssstyle.maxWidth;
            }
            if (textDomObject.getTextWidth(textDomObject.mTextPaint, width, false) > 0.0f) {
                textDomObject.layout = textDomObject.createLayout(width, false, null);
                textDomObject.hasBeenMeasured = true;
                textDomObject.previousWidth = textDomObject.layout.getWidth();
                measureOutput.height = textDomObject.layout.getHeight();
                measureOutput.width = textDomObject.previousWidth;
            } else {
                measureOutput.height = 0.0f;
                measureOutput.width = 0.0f;
            }
        }
    };
    private static final Canvas DUMMY_CANVAS = new Canvas();
    private static final String ELLIPSIS = "\u2026";
    private boolean mIsColorSet = false;
    private boolean hasBeenMeasured = false;
    private int mColor;
    private int mFontStyle = -1;
    private int mFontWeight = -1;
    private int mNumberOfLines = -1;
    private int mFontSize = -1;
    private int mLineHeight = -1;
    private float previousWidth = Float.NaN;
    private String mFontFamily = null;
    private String mText = null;
    private TextUtils.TruncateAt textOverflow;
    private Layout.Alignment mAlignment;
    private WXTextDecoration mTextDecoration = WXTextDecoration.NONE;
    private TextPaint mTextPaint = new TextPaint();
    @Nullable
    private Spanned spanned;
    @Nullable
    private Layout layout;
    private AtomicReference<Layout> atomicReference = new AtomicReference();

    public WXTextDomObject() {
        this.mTextPaint.setFlags(1);
        this.setMeasureFunction(TEXT_MEASURE_FUNCTION);
    }

    public TextPaint getTextPaint() {
        return this.mTextPaint;
    }

    @Override
    public void layoutBefore() {
        this.hasBeenMeasured = false;
        this.updateStyleAndText();
        this.spanned = this.createSpanned(this.mText);
        super.dirty();
        super.layoutBefore();
    }

    @Override
    public void layoutAfter() {
        if (this.hasBeenMeasured) {
            if (this.layout != null && !FloatUtil.floatsEqual(WXDomUtils.getContentWidth(this), this.previousWidth)) {
                this.recalculateLayout();
            }
        } else {
            this.updateStyleAndText();
            this.recalculateLayout();
        }
        this.hasBeenMeasured = false;
        if (this.layout != null && !this.layout.equals(this.atomicReference.get()) && Build.VERSION.SDK_INT >= 19) {
            this.warmUpTextLayoutCache(this.layout);
        }
        this.swap();
        super.layoutAfter();
    }

    public Layout getExtra() {
        return this.atomicReference.get();
    }

    @Override
    public void updateAttr(Map<String, Object> attrs) {
        this.swap();
        super.updateAttr(attrs);
        if (attrs.containsKey("value")) {
            this.mText = WXAttr.getValue(attrs);
        }
    }

    @Override
    public void updateStyle(Map<String, Object> styles) {
        this.swap();
        super.updateStyle(styles);
        this.updateStyleImp(styles);
    }

    @Override
    public WXTextDomObject clone() {
        WXTextDomObject dom;
        block3: {
            dom = null;
            try {
                dom = new WXTextDomObject();
                this.copyFields(dom);
                dom.hasBeenMeasured = this.hasBeenMeasured;
                dom.atomicReference = this.atomicReference;
            }
            catch (Exception e) {
                if (!WXEnvironment.isApkDebugable()) break block3;
                WXLogUtils.e("WXTextDomObject clone error: ", e);
            }
        }
        if (dom != null) {
            dom.spanned = this.spanned;
        }
        return dom;
    }

    private void recalculateLayout() {
        float contentWidth = WXDomUtils.getContentWidth(this);
        if (contentWidth > 0.0f) {
            this.spanned = this.createSpanned(this.mText);
            this.layout = this.createLayout(contentWidth, true, this.layout);
            this.previousWidth = this.layout.getWidth();
        }
    }

    private void updateStyleAndText() {
        this.updateStyleImp(this.getStyles());
        this.mText = WXAttr.getValue(this.getAttrs());
    }

    private void updateStyleImp(Map<String, Object> style) {
        if (style != null) {
            int lines;
            if (style.containsKey("lines") && (lines = WXStyle.getLines(style)) > 0) {
                this.mNumberOfLines = lines;
            }
            if (style.containsKey("fontSize")) {
                this.mFontSize = WXStyle.getFontSize(style, this.getViewPortWidth());
            }
            if (style.containsKey("fontWeight")) {
                this.mFontWeight = WXStyle.getFontWeight(style);
            }
            if (style.containsKey("fontStyle")) {
                this.mFontStyle = WXStyle.getFontStyle(style);
            }
            if (style.containsKey("color")) {
                this.mColor = WXResourceUtils.getColor(WXStyle.getTextColor(style));
                boolean bl = this.mIsColorSet = this.mColor != Integer.MIN_VALUE;
            }
            if (style.containsKey("textDecoration")) {
                this.mTextDecoration = WXStyle.getTextDecoration(style);
            }
            if (style.containsKey("fontFamily")) {
                this.mFontFamily = WXStyle.getFontFamily(style);
            }
            this.mAlignment = WXStyle.getTextAlignment(style);
            this.textOverflow = WXStyle.getTextOverflow(style);
            int lineHeight = WXStyle.getLineHeight(style, this.getViewPortWidth());
            if (lineHeight != -1) {
                this.mLineHeight = lineHeight;
            }
        }
    }

    @NonNull
    private Layout createLayout(float width, boolean forceWidth, @Nullable Layout previousLayout) {
        int lastLineEnd;
        int lastLineStart;
        float textWidth = this.getTextWidth(this.mTextPaint, width, forceWidth);
        Object layout = !FloatUtil.floatsEqual(this.previousWidth, textWidth) || previousLayout == null ? new StaticLayout((CharSequence)this.spanned, this.mTextPaint, (int)Math.ceil(textWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false) : previousLayout;
        if (this.mNumberOfLines != -1 && this.mNumberOfLines > 0 && this.mNumberOfLines < layout.getLineCount() && (lastLineStart = layout.getLineStart(this.mNumberOfLines - 1)) < (lastLineEnd = layout.getLineEnd(this.mNumberOfLines - 1))) {
            String text = this.mText.subSequence(0, lastLineStart).toString() + this.truncate(this.mText.substring(lastLineStart, lastLineEnd), this.mTextPaint, layout.getWidth(), this.textOverflow);
            this.spanned = this.createSpanned(text);
            return new StaticLayout((CharSequence)this.spanned, this.mTextPaint, (int)Math.ceil(textWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        }
        return layout;
    }

    @NonNull
    public String truncate(@Nullable String source, @NonNull TextPaint paint, int desired, @Nullable TextUtils.TruncateAt truncateAt) {
        if (!TextUtils.isEmpty((CharSequence)source)) {
            for (int i = source.length(); i > 0; --i) {
                Spanned spanned;
                StaticLayout layout;
                StringBuilder builder = new StringBuilder(i + 1);
                builder.append(source, 0, i);
                if (truncateAt != null) {
                    builder.append(ELLIPSIS);
                }
                if ((layout = new StaticLayout((CharSequence)(spanned = this.createSpanned(builder.toString())), paint, desired, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true)).getLineCount() > 1) continue;
                return spanned.toString();
            }
        }
        return "";
    }

    float getTextWidth(TextPaint textPaint, float outerWidth, boolean forceToDesired) {
        float textWidth;
        if (forceToDesired) {
            textWidth = outerWidth;
        } else {
            float desiredWidth = Layout.getDesiredWidth((CharSequence)this.spanned, (TextPaint)textPaint);
            textWidth = CSSConstants.isUndefined(outerWidth) || desiredWidth < outerWidth ? desiredWidth : outerWidth;
        }
        return textWidth;
    }

    @NonNull
    protected Spanned createSpanned(String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            SpannableString spannable = new SpannableString((CharSequence)text);
            this.updateSpannable((Spannable)spannable, 17);
            return spannable;
        }
        return new SpannableString((CharSequence)"");
    }

    protected void updateSpannable(Spannable spannable, int spanFlag) {
        List<SetSpanOperation> ops = this.createSetSpanOperation(spannable.length(), spanFlag);
        if (this.mFontSize == -1) {
            ops.add(new SetSpanOperation(0, spannable.length(), new AbsoluteSizeSpan(32), spanFlag));
        }
        Collections.reverse(ops);
        for (SetSpanOperation op : ops) {
            op.execute(spannable);
        }
    }

    private List<SetSpanOperation> createSetSpanOperation(int end, int spanFlag) {
        LinkedList<SetSpanOperation> ops = new LinkedList<SetSpanOperation>();
        int start = 0;
        if (end >= start) {
            if (this.mTextDecoration == WXTextDecoration.UNDERLINE) {
                ops.add(new SetSpanOperation(start, end, new UnderlineSpan(), spanFlag));
            }
            if (this.mTextDecoration == WXTextDecoration.LINETHROUGH) {
                ops.add(new SetSpanOperation(start, end, new StrikethroughSpan(), spanFlag));
            }
            if (this.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ForegroundColorSpan(this.mColor), spanFlag));
            }
            if (this.mFontSize != -1) {
                ops.add(new SetSpanOperation(start, end, new AbsoluteSizeSpan(this.mFontSize), spanFlag));
            }
            if (this.mFontStyle != -1 || this.mFontWeight != -1 || this.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, (Object)new WXCustomStyleSpan(this.mFontStyle, this.mFontWeight, this.mFontFamily), spanFlag));
            }
            ops.add(new SetSpanOperation(start, end, new AlignmentSpan.Standard(this.mAlignment), spanFlag));
            if (this.mLineHeight != -1) {
                ops.add(new SetSpanOperation(start, end, new WXLineHeightSpan(this.mLineHeight), spanFlag));
            }
        }
        return ops;
    }

    private void swap() {
        if (this.layout != null) {
            this.atomicReference.set(this.layout);
            this.layout = null;
            this.mTextPaint = new TextPaint((Paint)this.mTextPaint);
        }
    }

    private boolean warmUpTextLayoutCache(Layout layout) {
        boolean result;
        try {
            layout.draw(DUMMY_CANVAS);
            result = true;
        }
        catch (Exception e) {
            WXLogUtils.eTag(TAG, e);
            result = false;
        }
        return result;
    }

    private static class SetSpanOperation {
        protected final int start;
        protected final int end;
        protected final int flag;
        protected final Object what;

        SetSpanOperation(int start, int end, Object what) {
            this(start, end, what, 17);
        }

        SetSpanOperation(int start, int end, Object what, int flag) {
            this.start = start;
            this.end = end;
            this.what = what;
            this.flag = flag;
        }

        public void execute(Spannable sb) {
            sb.setSpan(this.what, this.start, this.end, this.flag);
        }
    }
}

