/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.dom.WXImageQuality;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class WXAttr
implements Map<String, Object>,
Cloneable {
    private static final long serialVersionUID = -2619357510079360946L;
    @NonNull
    private final ArrayMap<String, Object> map = new ArrayMap();

    public WXAttr() {
    }

    public WXAttr(@NonNull Map<String, Object> standardMap) {
        this();
        this.map.putAll(standardMap);
    }

    public static String getPrefix(Map<String, Object> attr) {
        if (attr == null) {
            return null;
        }
        Object src = attr.get("prefix");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public static String getSuffix(Map<String, Object> attr) {
        if (attr == null) {
            return null;
        }
        Object src = attr.get("suffix");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public static String getValue(Map<String, Object> attr) {
        if (attr == null) {
            return null;
        }
        Object src = attr.get("value");
        if (src == null && (src = attr.get("content")) == null) {
            return null;
        }
        return src.toString();
    }

    public WXImageQuality getImageQuality() {
        Object obj = this.get("quality");
        if (obj == null) {
            obj = this.get("imageQuality");
        }
        if (obj == null) {
            return WXImageQuality.LOW;
        }
        WXImageQuality waImageQuality = WXImageQuality.LOW;
        String imageQuality = obj.toString();
        if (imageQuality.equals("original")) {
            waImageQuality = WXImageQuality.ORIGINAL;
        } else if (imageQuality.equals("low")) {
            waImageQuality = WXImageQuality.LOW;
        } else if (imageQuality.equals("normal")) {
            waImageQuality = WXImageQuality.NORMAL;
        } else if (imageQuality.equals("high")) {
            waImageQuality = WXImageQuality.HIGH;
        }
        return waImageQuality;
    }

    public WXImageSharpen getImageSharpen() {
        Object obj = this.get("sharpen");
        if (obj == null) {
            obj = this.get("imageSharpen");
        }
        if (obj == null) {
            return WXImageSharpen.UNSHARPEN;
        }
        String imageSharpen = obj.toString();
        WXImageSharpen waImageSharpen = WXImageSharpen.UNSHARPEN;
        if (imageSharpen.equals("sharpen")) {
            waImageSharpen = WXImageSharpen.SHARPEN;
        }
        return waImageSharpen;
    }

    public String getImageSrc() {
        Object src = this.get("src");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public boolean showIndicators() {
        Object obj = this.get("showIndicators");
        if (obj == null) {
            return true;
        }
        try {
            return Boolean.parseBoolean(String.valueOf(obj));
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] showIndicators:", e);
            return true;
        }
    }

    public boolean autoPlay() {
        Object obj = this.get("autoPlay");
        if (obj == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(String.valueOf(obj));
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] autoPlay:", e);
            return false;
        }
    }

    public String getScope() {
        Object src = this.get("scope");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public String getLoadMoreRetry() {
        Object src = this.get("loadmoreretry");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public String getLoadMoreOffset() {
        Object src = this.get("loadmoreoffset");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public String optString(String key) {
        if (this.containsKey(key)) {
            Object value = this.get(key);
            if (value instanceof String) {
                return (String)value;
            }
            if (value != null) {
                return String.valueOf(value);
            }
        }
        return "";
    }

    public boolean getIsRecycleImage() {
        Object obj = this.get("recycleImage");
        if (obj == null) {
            return true;
        }
        try {
            return Boolean.parseBoolean(String.valueOf(obj));
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] recycleImage:", e);
            return false;
        }
    }

    public String getScrollDirection() {
        Object scrollDirection = this.get("scrollDirection");
        if (scrollDirection == null) {
            return "vertical";
        }
        return scrollDirection.toString();
    }

    public float getElevation(int viewPortW) {
        Object obj = this.get("elevation");
        float ret = Float.NaN;
        if (obj != null) {
            String number = obj.toString();
            ret = !TextUtils.isEmpty((CharSequence)number) ? WXViewUtils.getRealSubPxByWidth(WXUtils.getFloat(number), viewPortW) : 0.0f;
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put((Object)key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.map.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        return this.map.values();
    }

    protected WXAttr clone() {
        return new WXAttr((Map<String, Object>)this.map);
    }
}

