/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.text.TextUtils;
import com.taobao.weex.bridge.WXBridgeManager;
import java.util.Map;

public class WXServiceManager {
    public static boolean registerService(String name, String serviceScript, Map<String, String> options) {
        if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)serviceScript)) {
            return false;
        }
        String param1 = "register: global.registerService, unregister: global.unregisterService";
        String param2 = "serviceName: \"" + name + "\"";
        for (String key : options.keySet()) {
            String value = options.get(key);
            param2 = param2 + ", " + key + ": \"" + value + "\"";
        }
        String serviceJs = String.format("(function(service, options){ %s })({ %s }, { %s })", serviceScript, param1, param2);
        WXBridgeManager.getInstance().execJSService(serviceJs);
        return true;
    }

    public static boolean unRegisterService(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        String js = String.format("global.unregisterService( \"%s\" );", name);
        WXBridgeManager.getInstance().execJSService(js);
        return true;
    }
}

