/*
 * Decompiled with CFR 0.152.
 */
package com.tailoredapps.androidutil.ui.rxviews;

import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.tailoredapps.androidutil.ui.rxviews.BottomSheetBehaviorEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/tailoredapps/androidutil/ui/rxviews/BottomSheetBehaviorSlideEventObservable;", "Lio/reactivex/Observable;", "Lcom/tailoredapps/androidutil/ui/rxviews/BottomSheetBehaviorEvent;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "subscribeActual", "", "observer", "Lio/reactivex/Observer;", "Listener", "ui_release"})
public final class BottomSheetBehaviorSlideEventObservable
extends Observable<BottomSheetBehaviorEvent> {
    private final View view;

    protected void subscribeActual(@NotNull Observer<? super BottomSheetBehaviorEvent> observer) {
        Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
        if (!(this.view.getLayoutParams() instanceof CoordinatorLayout.LayoutParams)) {
            throw (Throwable)new IllegalArgumentException("The view is not in a Coordinator Layout.");
        }
        ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.coordinatorlayout.widget.CoordinatorLayout.LayoutParams");
        }
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)layoutParams;
        BottomSheetBehavior bottomSheetBehavior = (BottomSheetBehavior)params.getBehavior();
        if (bottomSheetBehavior == null) {
            throw (Throwable)new IllegalStateException("There's no behavior set on this view.");
        }
        BottomSheetBehavior behavior = bottomSheetBehavior;
        Listener listener = new Listener(behavior, observer);
        observer.onSubscribe((Disposable)listener);
        behavior.setBottomSheetCallback(listener.getBottomSheetCallback$ui_release());
    }

    public BottomSheetBehaviorSlideEventObservable(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.view = view;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/tailoredapps/androidutil/ui/rxviews/BottomSheetBehaviorSlideEventObservable$Listener;", "Lio/reactivex/android/MainThreadDisposable;", "bottomSheetBehavior", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "observer", "Lio/reactivex/Observer;", "Lcom/tailoredapps/androidutil/ui/rxviews/BottomSheetBehaviorEvent;", "(Lcom/tailoredapps/androidutil/ui/rxviews/BottomSheetBehaviorSlideEventObservable;Lcom/google/android/material/bottomsheet/BottomSheetBehavior;Lio/reactivex/Observer;)V", "bottomSheetCallback", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior$BottomSheetCallback;", "getBottomSheetCallback$ui_release", "()Lcom/google/android/material/bottomsheet/BottomSheetBehavior$BottomSheetCallback;", "onDispose", "", "ui_release"})
    private final class Listener
    extends MainThreadDisposable {
        @NotNull
        private final BottomSheetBehavior.BottomSheetCallback bottomSheetCallback;
        private final BottomSheetBehavior<?> bottomSheetBehavior;

        @NotNull
        public final BottomSheetBehavior.BottomSheetCallback getBottomSheetCallback$ui_release() {
            return this.bottomSheetCallback;
        }

        protected void onDispose() {
            this.bottomSheetBehavior.setBottomSheetCallback(null);
        }

        public Listener(@NotNull BottomSheetBehavior<?> bottomSheetBehavior, final Observer<? super BottomSheetBehaviorEvent> observer) {
            Intrinsics.checkParameterIsNotNull(bottomSheetBehavior, (String)"bottomSheetBehavior");
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            this.bottomSheetBehavior = bottomSheetBehavior;
            this.bottomSheetCallback = new BottomSheetBehavior.BottomSheetCallback(){

                public void onStateChanged(@NotNull View bottomSheet, int newState) {
                    Intrinsics.checkParameterIsNotNull((Object)bottomSheet, (String)"bottomSheet");
                    observer.onNext((Object)new BottomSheetBehaviorEvent.State(bottomSheet, newState));
                }

                public void onSlide(@NotNull View bottomSheet, float slideOffset) {
                    Intrinsics.checkParameterIsNotNull((Object)bottomSheet, (String)"bottomSheet");
                    observer.onNext((Object)new BottomSheetBehaviorEvent.Slide(bottomSheet, slideOffset));
                }
            };
        }
    }
}

