/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.AuthModule;
import com.suse.salt.netapi.calls.Call;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.wheel.Key;
import com.suse.salt.netapi.client.ConnectionFactory;
import com.suse.salt.netapi.client.impl.HttpClientConnectionFactory;
import com.suse.salt.netapi.config.ClientConfig;
import com.suse.salt.netapi.config.ProxySettings;
import com.suse.salt.netapi.datatypes.Job;
import com.suse.salt.netapi.datatypes.ScheduledJob;
import com.suse.salt.netapi.datatypes.Token;
import com.suse.salt.netapi.datatypes.cherrypy.Stats;
import com.suse.salt.netapi.datatypes.target.Target;
import com.suse.salt.netapi.event.EventListener;
import com.suse.salt.netapi.event.EventStream;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.parser.JsonParser;
import com.suse.salt.netapi.results.ResultInfoSet;
import com.suse.salt.netapi.results.Return;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SaltClient {
    private final ClientConfig config = new ClientConfig();
    private final ConnectionFactory connectionFactory;
    private final ExecutorService executor;
    private final Gson gson = new GsonBuilder().create();

    public SaltClient(URI url) {
        this(url, new HttpClientConnectionFactory());
    }

    public SaltClient(URI url, ConnectionFactory connectionFactory) {
        this(url, connectionFactory, Executors.newCachedThreadPool());
    }

    public SaltClient(URI url, ExecutorService executor) {
        this(url, new HttpClientConnectionFactory(), executor);
    }

    public SaltClient(URI url, ConnectionFactory connectionFactory, ExecutorService executor) {
        this.config.put(ClientConfig.URL, url);
        this.connectionFactory = connectionFactory;
        this.executor = executor;
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public void setProxy(ProxySettings settings) {
        if (settings.getHostname() != null) {
            this.config.put(ClientConfig.PROXY_HOSTNAME, settings.getHostname());
            this.config.put(ClientConfig.PROXY_PORT, settings.getPort());
        }
        if (settings.getUsername() != null) {
            this.config.put(ClientConfig.PROXY_USERNAME, settings.getUsername());
            if (settings.getPassword() != null) {
                this.config.put(ClientConfig.PROXY_PASSWORD, settings.getPassword());
            }
        }
    }

    public Token login(String username, String password, AuthModule eauth) throws SaltException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("username", username);
        props.put("password", password);
        props.put("eauth", eauth.getValue());
        String payload = this.gson.toJson(props);
        Return<List<Token>> result = this.connectionFactory.create("/login", JsonParser.TOKEN, this.config).getResult(payload);
        Token token = result.getResult().get(0);
        this.config.put(ClientConfig.TOKEN, token.getToken());
        return token;
    }

    public Future<Token> loginAsync(String username, String password, AuthModule eauth) {
        return this.executor.submit(() -> this.login(username, password, eauth));
    }

    public boolean logout() throws SaltException {
        String logoutMessage = "Your token has been cleared";
        Return<String> stringResult = this.connectionFactory.create("/logout", JsonParser.STRING, this.config).getResult("");
        boolean result = logoutMessage.equals(stringResult.getResult());
        if (result) {
            this.config.remove(ClientConfig.TOKEN);
        }
        return result;
    }

    public Future<Boolean> logoutAsync() {
        return this.executor.submit(() -> this.logout());
    }

    public Map<String, Map<String, Object>> getMinions() throws SaltException {
        return this.connectionFactory.create("/minions", JsonParser.RETMAPS, this.config).getResult().getResult().get(0);
    }

    public Future<Map<String, Map<String, Object>>> getMinionsAsync() throws SaltException {
        return this.executor.submit(this::getMinions);
    }

    public Map<String, Object> getMinionDetails(String minionId) throws SaltException {
        return this.connectionFactory.create("/minions/" + minionId, JsonParser.RETMAPS, this.config).getResult().getResult().get(0).get(minionId);
    }

    public Future<Map<String, Object>> getMinionDetailsAsync(String minionId) throws SaltException {
        return this.executor.submit(() -> this.getMinionDetails(minionId));
    }

    public <T> ScheduledJob startCommand(Target<T> target, String function, List<Object> args, Map<String, Object> kwargs) throws SaltException {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("tgt", target.getTarget());
        props.put("expr_form", target.getType());
        props.put("fun", function);
        props.put("arg", args);
        props.put("kwarg", kwargs);
        String payload = this.gson.toJson(Collections.singleton(props));
        Return<List<ScheduledJob>> result = this.connectionFactory.create("/minions", JsonParser.SCHEDULED_JOB, this.config).getResult(payload);
        return result.getResult().get(0);
    }

    public <T> Future<ScheduledJob> startCommandAsync(Target<T> target, String function, List<Object> args, Map<String, Object> kwargs) {
        return this.executor.submit(() -> this.startCommand(target, function, args, kwargs));
    }

    public ResultInfoSet getJobResult(ScheduledJob job) throws SaltException {
        return this.getJobResult(job.getJid());
    }

    public ResultInfoSet getJobResult(String job) throws SaltException {
        return this.connectionFactory.create("/jobs/" + job, JsonParser.JOB_RESULTS, this.config).getResult();
    }

    public Map<String, Job> getJobs() throws SaltException {
        Return<List<Map<String, Job>>> result = this.connectionFactory.create("/jobs", JsonParser.JOBS, this.config).getResult();
        return result.getResult().get(0);
    }

    public Future<Map<String, Job>> getJobsAsync() {
        return this.executor.submit(this::getJobs);
    }

    public <T> Map<String, Object> run(String username, String password, AuthModule eauth, String client, Target<T> target, String function, List<Object> args, Map<String, Object> kwargs) throws SaltException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("username", username);
        props.put("password", password);
        props.put("eauth", eauth.getValue());
        props.put("client", client);
        props.put("tgt", target.getTarget());
        props.put("expr_form", target.getType());
        props.put("fun", function);
        props.put("arg", args);
        props.put("kwarg", kwargs);
        List list = Collections.singletonList(props);
        String payload = this.gson.toJson(list);
        Return<List<Map<String, Object>>> result = this.connectionFactory.create("/run", JsonParser.RUN_RESULTS, this.config).getResult(payload);
        return result.getResult().get(0);
    }

    public <T> Future<Map<String, Object>> runAsync(String username, String password, AuthModule eauth, String client, Target<T> target, String function, List<Object> args, Map<String, Object> kwargs) {
        return this.executor.submit(() -> this.run(username, password, eauth, client, target, function, args, kwargs));
    }

    public Stats stats() throws SaltException {
        return this.connectionFactory.create("/stats", JsonParser.STATS, this.config).getResult();
    }

    public Future<Stats> statsAsync() {
        return this.executor.submit(this::stats);
    }

    public Key.Names keys() throws SaltException {
        return this.connectionFactory.create("/keys", JsonParser.KEYS, this.config).getResult().getResult();
    }

    public Future<Key.Names> keysAsync() {
        return this.executor.submit(this::keys);
    }

    public EventStream events(EventListener ... listeners) throws SaltException {
        return new EventStream(this.config, listeners);
    }

    public boolean sendEvent(String eventTag, String eventData) throws SaltException {
        String tag = eventTag != null ? eventTag : "";
        Map<String, Object> result = this.connectionFactory.create("/hook/" + tag, JsonParser.MAP, this.config).getResult(eventData);
        return Boolean.TRUE.equals(result.get("success"));
    }

    public Future<Boolean> sendEventAsync(String eventTag, String eventData) {
        return this.executor.submit(() -> this.sendEvent(eventTag, eventData));
    }

    public <R> R call(Call<?> call, Client client, String endpoint, Optional<Map<String, Object>> custom, TypeToken<R> type) throws SaltException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(call.getPayload());
        props.put("client", client.getValue());
        custom.ifPresent(props::putAll);
        List list = Collections.singletonList(props);
        String payload = this.gson.toJson(list);
        return this.connectionFactory.create(endpoint, new JsonParser<R>(type), this.config).getResult(payload);
    }

    public <R> R call(Call<?> call, Client client, String endpoint, TypeToken<R> type) throws SaltException {
        return this.call(call, client, endpoint, Optional.empty(), type);
    }
}

