/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.modules;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.LocalCall;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Pkg {
    private Pkg() {
    }

    public static LocalCall<Map<String, PackageInfo>> search(String criteria) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("criteria", criteria);
        return new LocalCall<Map<String, PackageInfo>>("pkg.search", Optional.empty(), Optional.of(args), new TypeToken<Map<String, PackageInfo>>(){});
    }

    public static LocalCall<PackageDict> fileDict(String ... packages) {
        return new LocalCall<PackageDict>("pkg.file_dict", Optional.of(Arrays.asList(packages)), Optional.empty(), new TypeToken<PackageDict>(){});
    }

    public static LocalCall<Map<String, List<String>>> listPkgs() {
        LinkedHashMap<String, Boolean> args = new LinkedHashMap<String, Boolean>();
        args.put("versions_as_list", true);
        return new LocalCall<Map<String, List<String>>>("pkg.list_pkgs", Optional.empty(), Optional.of(args), new TypeToken<Map<String, List<String>>>(){});
    }

    public static LocalCall<Map<String, Info>> infoInstalled(List<String> attributes, boolean reportErrors, String ... packages) {
        LinkedHashMap<String, String> kwargs = new LinkedHashMap<String, String>();
        kwargs.put("attr", attributes.stream().collect(Collectors.joining(",")));
        if (reportErrors) {
            kwargs.put("errors", "report");
        }
        return new LocalCall<Map<String, Info>>("pkg.info_installed", Optional.of(Arrays.asList(packages)), Optional.of(kwargs), new TypeToken<Map<String, Info>>(){});
    }

    public static LocalCall<Map<String, Info>> infoAvailable(String ... packages) {
        return new LocalCall<Map<String, Info>>("pkg.info_available", Optional.of(Arrays.asList(packages)), Optional.empty(), new TypeToken<Map<String, Info>>(){});
    }

    public static LocalCall<Map<String, Object>> install(boolean refresh, List<String> pkgs) {
        LinkedHashMap<String, Object> kwargs = new LinkedHashMap<String, Object>();
        kwargs.put("refresh", refresh);
        kwargs.put("pkgs", pkgs);
        return new LocalCall<Map<String, Object>>("pkg.install", Optional.empty(), Optional.of(kwargs), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Map<String, Object>> install(boolean refresh, Map<String, String> pkgs) {
        LinkedHashMap<String, Object> kwargs = new LinkedHashMap<String, Object>();
        kwargs.put("refresh", refresh);
        kwargs.put("pkgs", Pkg.preparePkgs(pkgs));
        return new LocalCall<Map<String, Object>>("pkg.install", Optional.empty(), Optional.of(kwargs), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Map<String, Object>> remove(Map<String, String> pkgs) {
        LinkedHashMap<String, List<Map<String, String>>> kwargs = new LinkedHashMap<String, List<Map<String, String>>>();
        kwargs.put("pkgs", Pkg.preparePkgs(pkgs));
        return new LocalCall<Map<String, Object>>("pkg.remove", Optional.empty(), Optional.of(kwargs), new TypeToken<Map<String, Object>>(){});
    }

    private static List<Map<String, String>> preparePkgs(Map<String, String> pkgs) {
        return pkgs.entrySet().stream().map(e -> Collections.unmodifiableMap(Stream.of(e).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).collect(Collectors.toList());
    }

    public static class Info {
        @SerializedName(value="arch")
        private Optional<String> architecture = Optional.empty();
        @SerializedName(value="build_date")
        private Optional<ZonedDateTime> buildDate = Optional.empty();
        @SerializedName(value="build_date_time_t")
        private Optional<Long> buildDateUnixTime = Optional.empty();
        @SerializedName(value="build_host")
        private Optional<String> buildHost = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> group = Optional.empty();
        @SerializedName(value="install_date")
        private Optional<ZonedDateTime> installDate = Optional.empty();
        @SerializedName(value="install_date_time_t")
        private Optional<Long> installDateUnixTime = Optional.empty();
        private Optional<String> license = Optional.empty();
        @SerializedName(value="new_features_have_been_added")
        private Optional<String> newFeaturesHaveBeenAdded = Optional.empty();
        private Optional<String> packager = Optional.empty();
        private Optional<String> release = Optional.empty();
        private Optional<String> relocations = Optional.empty();
        private Optional<String> signature = Optional.empty();
        private Optional<String> size = Optional.empty();
        private Optional<String> source = Optional.empty();
        private Optional<String> summary = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> vendor = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<String> epoch = Optional.empty();

        public Optional<String> getArchitecture() {
            return this.architecture;
        }

        public Optional<ZonedDateTime> getBuildDate() {
            return this.buildDate;
        }

        public Optional<String> getBuildHost() {
            return this.buildHost;
        }

        public Optional<String> getGroup() {
            return this.group;
        }

        public Optional<String> getDescription() {
            return this.description;
        }

        public Optional<ZonedDateTime> getInstallDate() {
            return this.installDate;
        }

        public Optional<String> getLicense() {
            return this.license;
        }

        public Optional<String> getNewFeaturesHaveBeenAdded() {
            return this.newFeaturesHaveBeenAdded;
        }

        public Optional<String> getPackager() {
            return this.packager;
        }

        public Optional<String> getRelease() {
            return this.release;
        }

        public Optional<String> getRelocations() {
            return this.relocations;
        }

        public Optional<String> getSignature() {
            return this.signature;
        }

        public Optional<String> getSize() {
            return this.size;
        }

        public Optional<String> getSource() {
            return this.source;
        }

        public Optional<String> getSummary() {
            return this.summary;
        }

        public Optional<String> getUrl() {
            return this.url;
        }

        public Optional<String> getVendor() {
            return this.vendor;
        }

        public Optional<String> getVersion() {
            return this.version;
        }

        public Optional<String> getEpoch() {
            return this.epoch;
        }

        public Optional<Long> getBuildDateUnixTime() {
            return this.buildDateUnixTime;
        }

        public Optional<Long> getInstallDateUnixTime() {
            return this.installDateUnixTime;
        }
    }

    public static class PackageDict {
        private List<Object> errors;
        private Map<String, List<String>> packages;

        public List<Object> getErrors() {
            return this.errors;
        }

        public Map<String, List<String>> getPackages() {
            return this.packages;
        }
    }

    public static class PackageInfo {
        private String summary;

        public String getSummary() {
            return this.summary;
        }
    }
}

