/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls;

import java.util.Optional;

public class SaltSSHConfig {
    private final Optional<String> extraFilerefs;
    private final Optional<Boolean> identitiesOnly;
    private final Optional<Boolean> ignoreHostKeys;
    private final Optional<Boolean> keyDeploy;
    private final Optional<Boolean> noHostKeys;
    private final Optional<String> passwd;
    private final Optional<String> priv;
    private final Optional<Boolean> rawShell;
    private final Optional<Boolean> refreshCache;
    private final Optional<String> remotePortForwards;
    private final Optional<String> roster;
    private final Optional<String> rosterFile;
    private final Optional<String> scanPorts;
    private final Optional<Double> scanTimeout;
    private final Optional<Integer> sshMaxProcs;
    private final Optional<Boolean> sudo;
    private final Optional<String> user;
    private final Optional<Boolean> wipe;

    private SaltSSHConfig(Builder builder) {
        this.extraFilerefs = builder.extraFilerefs;
        this.identitiesOnly = builder.identitiesOnly;
        this.ignoreHostKeys = builder.ignoreHostKeys;
        this.keyDeploy = builder.keyDeploy;
        this.noHostKeys = builder.noHostKeys;
        this.passwd = builder.passwd;
        this.priv = builder.priv;
        this.rawShell = builder.rawShell;
        this.refreshCache = builder.refreshCache;
        this.remotePortForwards = builder.remotePortForwards;
        this.roster = builder.roster;
        this.rosterFile = builder.rosterFile;
        this.scanPorts = builder.scanPorts;
        this.scanTimeout = builder.scanTimeout;
        this.sshMaxProcs = builder.sshMaxProcs;
        this.sudo = builder.sudo;
        this.user = builder.user;
        this.wipe = builder.wipe;
    }

    public Optional<String> getExtraFilerefs() {
        return this.extraFilerefs;
    }

    public Optional<Boolean> getIdentitiesOnly() {
        return this.identitiesOnly;
    }

    public Optional<Boolean> getIgnoreHostKeys() {
        return this.ignoreHostKeys;
    }

    public Optional<Boolean> getKeyDeploy() {
        return this.keyDeploy;
    }

    public Optional<Boolean> getNoHostKeys() {
        return this.noHostKeys;
    }

    public Optional<String> getPasswd() {
        return this.passwd;
    }

    public Optional<String> getPriv() {
        return this.priv;
    }

    public Optional<Boolean> getRawShell() {
        return this.rawShell;
    }

    public Optional<Boolean> getRefreshCache() {
        return this.refreshCache;
    }

    public Optional<String> getRemotePortForwards() {
        return this.remotePortForwards;
    }

    public Optional<String> getRoster() {
        return this.roster;
    }

    public Optional<String> getRosterFile() {
        return this.rosterFile;
    }

    public Optional<String> getScanPorts() {
        return this.scanPorts;
    }

    public Optional<Double> getScanTimeout() {
        return this.scanTimeout;
    }

    public Optional<Integer> getSSHMaxProcs() {
        return this.sshMaxProcs;
    }

    public Optional<Boolean> getSudo() {
        return this.sudo;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public Optional<Boolean> getWipe() {
        return this.wipe;
    }

    public static class Builder {
        private Optional<String> extraFilerefs = Optional.empty();
        private Optional<Boolean> identitiesOnly = Optional.empty();
        private Optional<Boolean> ignoreHostKeys = Optional.empty();
        private Optional<Boolean> keyDeploy = Optional.empty();
        private Optional<Boolean> noHostKeys = Optional.empty();
        private Optional<String> passwd = Optional.empty();
        private Optional<String> priv = Optional.empty();
        private Optional<Boolean> rawShell = Optional.empty();
        private Optional<Boolean> refreshCache = Optional.empty();
        private Optional<String> remotePortForwards = Optional.empty();
        private Optional<String> roster = Optional.empty();
        private Optional<String> rosterFile = Optional.empty();
        private Optional<String> scanPorts = Optional.empty();
        private Optional<Double> scanTimeout = Optional.empty();
        private Optional<Boolean> sudo = Optional.empty();
        private Optional<Integer> sshMaxProcs = Optional.empty();
        private Optional<String> user = Optional.empty();
        private Optional<Boolean> wipe = Optional.empty();

        public Builder extraFilerefs(String extraFilerefs) {
            this.extraFilerefs = Optional.of(extraFilerefs);
            return this;
        }

        public Builder identitiesOnly(boolean identitiesOnly) {
            this.identitiesOnly = Optional.of(identitiesOnly);
            return this;
        }

        public Builder ignoreHostKeys(boolean ignoreHostKeys) {
            this.ignoreHostKeys = Optional.of(ignoreHostKeys);
            return this;
        }

        public Builder keyDeploy(boolean keyDeploy) {
            this.keyDeploy = Optional.of(keyDeploy);
            return this;
        }

        public Builder noHostKeys(boolean noHostKeys) {
            this.noHostKeys = Optional.of(noHostKeys);
            return this;
        }

        public Builder passwd(String passwd) {
            this.passwd = Optional.of(passwd);
            return this;
        }

        public Builder priv(String priv) {
            this.priv = Optional.of(priv);
            return this;
        }

        public Builder rawShell(boolean rawShell) {
            this.rawShell = Optional.of(rawShell);
            return this;
        }

        public Builder refreshCache(boolean refreshCache) {
            this.refreshCache = Optional.of(refreshCache);
            return this;
        }

        public Builder remotePortForwards(String remotePortForwards) {
            this.remotePortForwards = Optional.of(remotePortForwards);
            return this;
        }

        public Builder roster(String roster) {
            this.roster = Optional.of(roster);
            return this;
        }

        public Builder rosterFile(String rosterFile) {
            this.rosterFile = Optional.of(rosterFile);
            return this;
        }

        public Builder scanPorts(String scanPorts) {
            this.scanPorts = Optional.of(scanPorts);
            return this;
        }

        public Builder scanTimeout(Double scanTimeout) {
            this.scanTimeout = Optional.of(scanTimeout);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.sudo = Optional.of(sudo);
            return this;
        }

        public Builder sshMaxProcs(int sshMaxProcs) {
            this.sshMaxProcs = Optional.of(sshMaxProcs);
            return this;
        }

        public Builder user(String user) {
            this.user = Optional.of(user);
            return this;
        }

        public Builder wipe(boolean wipe) {
            this.wipe = Optional.of(wipe);
            return this;
        }

        public SaltSSHConfig build() {
            return new SaltSSHConfig(this);
        }
    }
}

