/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.AuthModule;
import com.suse.salt.netapi.calls.Call;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.LocalAsyncResult;
import com.suse.salt.netapi.calls.SaltSSHConfig;
import com.suse.salt.netapi.client.SaltClient;
import com.suse.salt.netapi.datatypes.target.Target;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.results.Return;
import com.suse.salt.netapi.results.SSHResult;
import com.suse.salt.netapi.utils.ClientUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LocalCall<R>
implements Call<R> {
    private final String functionName;
    private final Optional<List<?>> arg;
    private final Optional<Map<String, ?>> kwarg;
    private final TypeToken<R> returnType;
    private final Optional<?> metadata;

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType, Optional<?> metadata) {
        this.functionName = functionName;
        this.arg = arg;
        this.kwarg = kwarg;
        this.returnType = returnType;
        this.metadata = metadata;
    }

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType) {
        this(functionName, arg, kwarg, returnType, Optional.empty());
    }

    public LocalCall<R> withMetadata(Object metadata) {
        return new LocalCall<R>(this.functionName, this.arg, this.kwarg, this.returnType, Optional.of(metadata));
    }

    public LocalCall<R> withoutMetadata() {
        return new LocalCall<R>(this.functionName, this.arg, this.kwarg, this.returnType, Optional.empty());
    }

    public TypeToken<R> getReturnType() {
        return this.returnType;
    }

    @Override
    public Map<String, Object> getPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("fun", this.functionName);
        this.arg.ifPresent(arg -> payload.put("arg", arg));
        this.kwarg.ifPresent(kwarg -> payload.put("kwarg", kwarg));
        this.metadata.ifPresent(m -> payload.put("metadata", m));
        return payload;
    }

    public LocalAsyncResult<R> callAsync(SaltClient client, Target<?> target) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        Return wrapper = (Return)client.call(this, Client.LOCAL_ASYNC, "/", Optional.of(customArgs), new TypeToken<Return<List<LocalAsyncResult<R>>>>(){});
        LocalAsyncResult result = (LocalAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public LocalAsyncResult<R> callAsync(SaltClient client, Target<?> target, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        Return wrapper = (Return)client.call(this, Client.LOCAL_ASYNC, "/run", Optional.of(customArgs), new TypeToken<Return<List<LocalAsyncResult<R>>>>(){});
        LocalAsyncResult result = (LocalAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public Map<String, Result<R>> callSync(SaltClient client, Target<?> target) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType map = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, xor});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{map});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        Return wrapper = (Return)client.call(this, Client.LOCAL, "/", Optional.of(customArgs), TypeToken.get((Type)wrapperType));
        return (Map)((List)wrapper.getResult()).get(0);
    }

    public Map<String, Result<R>> callSync(SaltClient client, Target<?> target, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType map = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, xor});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{map});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        Return wrapper = (Return)client.call(this, Client.LOCAL, "/run", Optional.of(customArgs), TypeToken.get((Type)wrapperType));
        return (Map)((List)wrapper.getResult()).get(0);
    }

    public Map<String, Result<SSHResult<R>>> callSyncSSH(SaltClient client, Target<?> target, SaltSSHConfig cfg) throws SaltException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.putAll(this.getPayload());
        args.put("tgt", target.getTarget());
        args.put("expr_form", target.getType());
        cfg.getExtraFilerefs().ifPresent(v -> args.put("extra_filerefs", v));
        cfg.getIdentitiesOnly().ifPresent(v -> args.put("ssh_identities_only", v));
        cfg.getIgnoreHostKeys().ifPresent(v -> args.put("ignore_host_keys", v));
        cfg.getKeyDeploy().ifPresent(v -> args.put("ssh_key_deploy", v));
        cfg.getNoHostKeys().ifPresent(v -> args.put("no_host_keys", v));
        cfg.getPasswd().ifPresent(v -> args.put("ssh_passwd", v));
        cfg.getPriv().ifPresent(v -> args.put("ssh_priv", v));
        cfg.getRawShell().ifPresent(v -> args.put("raw_shell", v));
        cfg.getRefreshCache().ifPresent(v -> args.put("refresh_cache", v));
        cfg.getRemotePortForwards().ifPresent(v -> args.put("ssh_remote_port_forwards", v));
        cfg.getRoster().ifPresent(v -> args.put("roster", v));
        cfg.getRosterFile().ifPresent(v -> args.put("roster_file", v));
        cfg.getScanPorts().ifPresent(v -> args.put("ssh_scan_ports", v));
        cfg.getScanTimeout().ifPresent(v -> args.put("ssh_scan_timeout", v));
        cfg.getSudo().ifPresent(v -> args.put("ssh_sudo", v));
        cfg.getSSHMaxProcs().ifPresent(v -> args.put("ssh_max_procs", v));
        cfg.getUser().ifPresent(v -> args.put("ssh_user", v));
        cfg.getWipe().ifPresent(v -> args.put("ssh_wipe", v));
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{ClientUtils.parameterizedType(null, SSHResult.class, new Type[]{this.getReturnType().getType()})});
        ParameterizedType map = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, xor});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{map});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        Return wrapper = (Return)client.call(this, Client.SSH, "/run", Optional.of(args), TypeToken.get((Type)wrapperType));
        return (Map)((List)wrapper.getResult()).get(0);
    }
}

