/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.suse.salt.netapi.calls.wheel.Key;
import com.suse.salt.netapi.datatypes.Arguments;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.datatypes.Job;
import com.suse.salt.netapi.datatypes.ScheduledJob;
import com.suse.salt.netapi.datatypes.StartTime;
import com.suse.salt.netapi.datatypes.Token;
import com.suse.salt.netapi.datatypes.cherrypy.Applications;
import com.suse.salt.netapi.datatypes.cherrypy.HttpServer;
import com.suse.salt.netapi.datatypes.cherrypy.Stats;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.results.ResultInfoSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonParser<T> {
    public static final JsonParser<Result<String>> STRING = new JsonParser<Result<String>>(new TypeToken<Result<String>>(){});
    public static final JsonParser<Result<List<Token>>> TOKEN = new JsonParser<Result<List<Token>>>(new TypeToken<Result<List<Token>>>(){});
    public static final JsonParser<Result<List<ScheduledJob>>> SCHEDULED_JOB = new JsonParser<Result<List<ScheduledJob>>>(new TypeToken<Result<List<ScheduledJob>>>(){});
    public static final JsonParser<Result<List<Map<String, Job>>>> JOBS = new JsonParser<Result<List<Map<String, Job>>>>(new TypeToken<Result<List<Map<String, Job>>>>(){});
    public static final JsonParser<ResultInfoSet> JOB_RESULTS = new JsonParser<ResultInfoSet>(new TypeToken<ResultInfoSet>(){});
    public static final JsonParser<Result<List<Map<String, Map<String, Object>>>>> RETMAPS = new JsonParser<Result<List<Map<String, Map<String, Object>>>>>(new TypeToken<Result<List<Map<String, Map<String, Object>>>>>(){});
    public static final JsonParser<Result<List<Map<String, Object>>>> RUN_RESULTS = new JsonParser<Result<List<Map<String, Object>>>>(new TypeToken<Result<List<Map<String, Object>>>>(){});
    public static final JsonParser<Stats> STATS = new JsonParser<Stats>(new TypeToken<Stats>(){});
    public static final JsonParser<Result<Key.Names>> KEYS = new JsonParser<Result<Key.Names>>(new TypeToken<Result<Key.Names>>(){});
    public static final JsonParser<Map<String, Object>> MAP = new JsonParser<Map<String, Object>>(new TypeToken<Map<String, Object>>(){});
    public static final JsonParser<Event> EVENTS = new JsonParser<Event>(new TypeToken<Event>(){});
    private final TypeToken<T> type;
    private final Gson gson;

    public JsonParser(TypeToken<T> type) {
        this.type = type;
        this.gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAdapter().nullSafe()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeISOAdapter()).registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeISOAdapter()).registerTypeAdapter(StartTime.class, (Object)new StartTimeAdapter().nullSafe()).registerTypeAdapter(Stats.class, (Object)new StatsAdapter()).registerTypeAdapter(Arguments.class, (Object)new ArgumentsAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).create();
    }

    public T parse(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader streamReader = new BufferedReader(inputStreamReader);
        return (T)this.gson.fromJson((Reader)streamReader, this.type.getType());
    }

    public T parse(String jsonString) {
        return (T)this.gson.fromJson(jsonString, this.type.getType());
    }

    private class ZonedDateTimeISOAdapter
    extends TypeAdapter<ZonedDateTime> {
        private ZonedDateTimeISOAdapter() {
        }

        public void write(JsonWriter jsonWriter, ZonedDateTime date) throws IOException {
            if (date == null) {
                throw new JsonParseException("null is not a valid value for ZonedDateTime");
            }
            jsonWriter.value(date.toString());
        }

        public ZonedDateTime read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                throw new JsonParseException("null is not a valid value for ZonedDateTime");
            }
            String dateStr = jsonReader.nextString();
            return ZonedDateTime.parse(dateStr);
        }
    }

    private class LocalDateTimeISOAdapter
    extends TypeAdapter<LocalDateTime> {
        private LocalDateTimeISOAdapter() {
        }

        public void write(JsonWriter jsonWriter, LocalDateTime date) throws IOException {
            if (date == null) {
                throw new JsonParseException("null is not a valid value for LocalDateTime");
            }
            jsonWriter.value(date.toString());
        }

        public LocalDateTime read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                throw new JsonParseException("null is not a valid value for LocalDateTime");
            }
            String dateStr = jsonReader.nextString();
            return LocalDateTime.parse(dateStr);
        }
    }

    private class StartTimeAdapter
    extends TypeAdapter<StartTime> {
        private StartTimeAdapter() {
        }

        public void write(JsonWriter jsonWriter, StartTime date) throws IOException {
            if (date == null) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.value(date.toString());
            }
        }

        public StartTime read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            String dateStr = jsonReader.nextString();
            String subStr = dateStr.substring(0, dateStr.length() - 3);
            return new StartTime(subStr);
        }
    }

    private class ArgumentsAdapter
    extends TypeAdapter<Arguments> {
        private static final String KWARG_KEY = "__kwarg__";

        private ArgumentsAdapter() {
        }

        public void write(JsonWriter jsonWriter, Arguments args) throws IOException {
            throw new UnsupportedOperationException("Writing JSON not supported.");
        }

        public Arguments read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                throw new JsonParseException("null is not a valid value for Arguments");
            }
            Arguments result = new Arguments();
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
                    Map<String, Object> arg = this.readObjectArgument(jsonReader);
                    if (this.isKwarg(arg)) {
                        arg.remove(KWARG_KEY);
                        result.getKwargs().putAll(arg);
                        continue;
                    }
                    result.getArgs().add(arg);
                    continue;
                }
                result.getArgs().add(JsonParser.this.gson.fromJson(jsonReader, Object.class));
            }
            jsonReader.endArray();
            return result;
        }

        private Map<String, Object> readObjectArgument(JsonReader jsonReader) throws IOException {
            LinkedHashMap<String, Object> arg = new LinkedHashMap<String, Object>();
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                arg.put(jsonReader.nextName(), JsonParser.this.gson.fromJson(jsonReader, Object.class));
            }
            jsonReader.endObject();
            return arg;
        }

        private boolean isKwarg(Map<String, Object> arg) {
            Object kwarg = arg.get(KWARG_KEY);
            return kwarg != null && kwarg instanceof Boolean && (Boolean)kwarg != false;
        }
    }

    private class StatsAdapter
    extends TypeAdapter<Stats> {
        private static final String CP_APPLICATIONS = "CherryPy Applications";
        private static final String CP_SERVER_PREFIX = "CherryPy HTTPServer ";

        private StatsAdapter() {
        }

        public void write(JsonWriter jsonWriter, Stats stats) throws IOException {
            throw new UnsupportedOperationException("Writing JSON not supported.");
        }

        public Stats read(JsonReader jsonReader) throws IOException {
            Applications app = null;
            HttpServer server = null;
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if (name.equals(CP_APPLICATIONS)) {
                    app = (Applications)JsonParser.this.gson.fromJson(jsonReader, Applications.class);
                    continue;
                }
                if (name.startsWith(CP_SERVER_PREFIX)) {
                    server = (HttpServer)JsonParser.this.gson.fromJson(jsonReader, HttpServer.class);
                    continue;
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            return new Stats(app, server);
        }
    }

    private class OptionalTypeAdapterFactory
    implements TypeAdapterFactory {
        private OptionalTypeAdapterFactory() {
        }

        public <A> TypeAdapter<A> create(Gson gson, TypeToken<A> typeToken) {
            Type type = typeToken.getType();
            boolean isOptional = typeToken.getRawType() == Optional.class;
            boolean isParameterized = type instanceof ParameterizedType;
            if (isOptional && isParameterized) {
                Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                TypeAdapter elementAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
                return this.optionalAdapter(elementAdapter);
            }
            return null;
        }

        private <A> TypeAdapter<Optional<A>> optionalAdapter(final TypeAdapter<A> innerAdapter) {
            return new TypeAdapter<Optional<A>>(){

                public Optional<A> read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.NULL) {
                        in.nextNull();
                        return Optional.empty();
                    }
                    Object value = innerAdapter.read(in);
                    return Optional.of(value);
                }

                public void write(JsonWriter out, Optional<A> optional) throws IOException {
                    innerAdapter.write(out, optional.orElse(null));
                }
            };
        }
    }

    private class DateAdapter
    extends TypeAdapter<Date> {
        private DateAdapter() {
        }

        public void write(JsonWriter jsonWriter, Date date) throws IOException {
            throw new UnsupportedOperationException("Writing JSON not supported.");
        }

        public Date read(JsonReader jsonReader) throws IOException {
            try {
                double dateMilliseconds = jsonReader.nextDouble() * 1000.0;
                return new Date((long)dateMilliseconds);
            }
            catch (IllegalStateException | NumberFormatException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }
}

