/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.suse.salt.netapi.datatypes.Event;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobReturnEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/job/([^/]+)/ret/([^/]+)$");
    private final String jobId;
    private final String minionId;
    private final Map<String, Object> data;

    public JobReturnEvent(String jobIdIn, String minionIdIn, Map<String, Object> dataIn) {
        this.jobId = jobIdIn;
        this.minionId = minionIdIn;
        this.data = dataIn;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getMinionId() {
        return this.minionId;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static Optional<JobReturnEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        if (matcher.matches()) {
            JobReturnEvent result = new JobReturnEvent(matcher.group(1), matcher.group(2), event.getData());
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

