/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.runner;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.Data;
import com.suse.salt.netapi.calls.LocalAsyncResult;
import com.suse.salt.netapi.calls.RunnerAsyncResult;
import com.suse.salt.netapi.calls.RunnerCall;
import com.suse.salt.netapi.calls.WheelAsyncResult;
import com.suse.salt.netapi.datatypes.StartTime;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.utils.ClientUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;

public class Jobs {
    private Jobs() {
    }

    public static RunnerCall<Map<String, Object>> lookupJid(String jid) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("jid", jid);
        return new RunnerCall<Map<String, Object>>("jobs.lookup_jid", Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static <R> RunnerCall<Map<String, R>> lookupJid(LocalAsyncResult<R> jid) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("jid", jid.getJid());
        ParameterizedType type = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, jid.getType().getType()});
        return new RunnerCall<Map<String, R>>("jobs.lookup_jid", Optional.of(args), TypeToken.get((Type)type));
    }

    public static <R> RunnerCall<Map<String, Data<R>>> lookupJid(WheelAsyncResult<R> jid) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("jid", jid.getJid());
        ParameterizedType dataType = ClientUtils.parameterizedType(null, Data.class, new Type[]{jid.getType().getType()});
        ParameterizedType type = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, dataType});
        return new RunnerCall<Map<String, Data<R>>>("jobs.lookup_jid", Optional.of(args), TypeToken.get((Type)type));
    }

    public static <R> RunnerCall<Map<String, Data<R>>> lookupJid(RunnerAsyncResult<R> jid) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("jid", jid.getJid());
        ParameterizedType dataType = ClientUtils.parameterizedType(null, Data.class, new Type[]{jid.getType().getType()});
        ParameterizedType type = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, dataType});
        return new RunnerCall<Map<String, Data<R>>>("jobs.lookup_jid", Optional.of(args), TypeToken.get((Type)type));
    }

    public static class Info<R> {
        @SerializedName(value="Function")
        private String function;
        private String jid;
        @SerializedName(value="StartTime")
        private StartTime startTime;
        @SerializedName(value="Arguments")
        private List<Object> arguments;
        @SerializedName(value="Minions")
        private Set<String> minions;
        @SerializedName(value="User")
        private String user;
        @SerializedName(value="Target")
        private String target;
        @SerializedName(value="Result")
        private Map<String, Result<R>> result;

        public String getFunction() {
            return this.function;
        }

        public String getJid() {
            return this.jid;
        }

        public Date getStartTime(TimeZone tz) {
            return this.startTime == null ? null : this.startTime.getDate(tz);
        }

        public Date getStartTime() {
            return this.startTime == null ? null : this.startTime.getDate();
        }

        public List<Object> getArguments() {
            return this.arguments;
        }

        public Set<String> getMinions() {
            return this.minions;
        }

        public String getUser() {
            return this.user;
        }

        public String getTarget() {
            return this.target;
        }

        public Map<String, Result<R>> getResult() {
            return this.result;
        }

        public Optional<R> resultOf(String minionKey) {
            return Optional.ofNullable(this.result).flatMap(r -> Optional.ofNullable(r.get(minionKey))).map(Result::getResult);
        }
    }
}

