/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.parser;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.suse.salt.netapi.errors.JsonParsingError;
import com.suse.salt.netapi.errors.SaltSSHError;
import com.suse.salt.netapi.parser.JsonParser;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.results.SSHResult;
import com.suse.salt.netapi.utils.ClientUtils;
import com.suse.salt.netapi.utils.SaltErrorUtils;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ResultSSHResultTypeAdapterFactory
implements TypeAdapterFactory {
    public <A> TypeAdapter<A> create(Gson gson, TypeToken<A> typeToken) {
        boolean isResult = typeToken.getRawType() == Result.class;
        Type type = typeToken.getType();
        boolean isSSHResult = ResultSSHResultTypeAdapterFactory.isResultSSHResult(type);
        if (isResult && isSSHResult) {
            Type parameterType = ((ParameterizedType)type).getActualTypeArguments()[0];
            TypeAdapter sshResultAdapter = gson.getAdapter(TypeToken.get((Type)parameterType));
            return this.resultAdapter(sshResultAdapter);
        }
        return null;
    }

    public static boolean isResultSSHResult(Type type) {
        boolean isParametrized = type instanceof ParameterizedType;
        if (!isParametrized) {
            return false;
        }
        Type[] innerType = ((ParameterizedType)type).getActualTypeArguments();
        return isParametrized && innerType.length > 0 && innerType[0] instanceof ParameterizedType && ((ParameterizedType)innerType[0]).getRawType() == SSHResult.class;
    }

    private <R> TypeAdapter<Result<SSHResult<R>>> resultAdapter(final TypeAdapter<SSHResult<R>> innerAdapter) {
        return new TypeAdapter<Result<SSHResult<R>>>(){

            public Result<SSHResult<R>> read(JsonReader in) throws IOException {
                JsonElement json = (JsonElement)TypeAdapters.JSON_ELEMENT.read(in);
                try {
                    SSHResult value = (SSHResult)innerAdapter.fromJsonTree(json);
                    if (!value.getReturn().isPresent() && value.getRetcode() != 0) {
                        throw new NullPointerException("No salt ssh return value, return code: " + value.getRetcode());
                    }
                    return Result.success(value);
                }
                catch (Throwable e) {
                    ParameterizedType sshResultType = ClientUtils.parameterizedType(null, SSHResult.class, new Type[]{JsonElement.class});
                    TypeToken typeToken = TypeToken.get((Type)sshResultType);
                    SSHResult result = (SSHResult)JsonParser.GSON.fromJson(json, typeToken.getType());
                    if (result.getRetcode() != 0) {
                        return Result.error(result.getStderr().flatMap(SaltErrorUtils::deriveError).orElse(new SaltSSHError(result.getRetcode(), "stderr: \"" + result.getStderr().orElse("") + "\", stdout: \"" + result.getStdout().orElse("") + "\"")));
                    }
                    return Result.error(new JsonParsingError(json, e));
                }
            }

            public void write(JsonWriter out, Result<SSHResult<R>> xor) throws IOException {
                throw new JsonParseException("Writing Xor is not supported");
            }
        };
    }
}

