/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.parser.JsonParser;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeaconEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/beacon/([^/]+)/([^/]+)/(.*)$");
    private static final Gson GSON = JsonParser.GSON;
    private final String beacon;
    private final String minionId;
    private final String additional;
    private final JsonElement data;

    private BeaconEvent(String minionId, String beacon, String additional, JsonElement data) {
        this.minionId = minionId;
        this.beacon = beacon;
        this.additional = additional;
        this.data = data;
    }

    public String getBeacon() {
        return this.beacon;
    }

    public String getMinionId() {
        return this.minionId;
    }

    public String getAdditional() {
        return this.additional;
    }

    public <R> R getData(TypeToken<R> type) {
        return (R)GSON.fromJson(this.data, type.getType());
    }

    public <R> R getData(Class<R> type) {
        return (R)GSON.fromJson(this.data, type);
    }

    public Map<String, Object> getData() {
        TypeToken<Map<String, Object>> typeToken = new TypeToken<Map<String, Object>>(){};
        return this.getData(typeToken);
    }

    public static Optional<BeaconEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        if (matcher.matches()) {
            BeaconEvent result = new BeaconEvent(matcher.group(1), matcher.group(2), matcher.group(3), event.getData(JsonElement.class));
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

