/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.AuthModule;
import com.suse.salt.netapi.calls.AbstractCall;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.RunnerAsyncResult;
import com.suse.salt.netapi.client.SaltClient;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.results.Return;
import com.suse.salt.netapi.utils.ClientUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RunnerCall<R>
extends AbstractCall<R> {
    private final Optional<Map<String, ?>> kwargs;

    public RunnerCall(String functionName, Optional<Map<String, ?>> kwargs, TypeToken<R> returnType) {
        super(functionName, returnType);
        this.kwargs = kwargs;
    }

    @Override
    public Map<String, Object> getPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("fun", this.getFunction());
        this.kwargs.ifPresent(kwargs -> payload.put("kwarg", kwargs));
        return payload;
    }

    public RunnerAsyncResult<R> callAsync(SaltClient client) throws SaltException {
        Return wrapper = (Return)client.call(this, Client.RUNNER_ASYNC, "/", new TypeToken<Return<List<RunnerAsyncResult<R>>>>(){});
        RunnerAsyncResult result = (RunnerAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public RunnerAsyncResult<R> callAsync(SaltClient client, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        Return wrapper = (Return)client.call(this, Client.RUNNER_ASYNC, "/run", Optional.of(customArgs), new TypeToken<Return<List<RunnerAsyncResult<R>>>>(){});
        RunnerAsyncResult result = (RunnerAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public Result<R> callSync(SaltClient client, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{xor});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        Return wrapper = (Return)client.call(this, Client.RUNNER, "/run", Optional.of(customArgs), TypeToken.get((Type)wrapperType));
        return (Result)((List)wrapper.getResult()).get(0);
    }

    public Result<R> callSync(SaltClient client) throws SaltException {
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{xor});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        Return wrapper = (Return)client.call(this, Client.RUNNER, "/", TypeToken.get((Type)wrapperType));
        return (Result)((List)wrapper.getResult()).get(0);
    }
}

