/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.parser.JsonParser;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RunnerReturnEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/run/(\\d+)/ret$");
    private final String jobId;
    private final Data data;
    private static final Gson GSON = JsonParser.GSON;

    private RunnerReturnEvent(String jobIdIn, Data dataIn) {
        this.jobId = jobIdIn;
        this.data = dataIn;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Data getData() {
        return this.data;
    }

    public static Optional<RunnerReturnEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        if (matcher.matches()) {
            Data data = event.getData(Data.class);
            RunnerReturnEvent result = new RunnerReturnEvent(matcher.group(1), data);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static class Data {
        @SerializedName(value="_stamp")
        private String timestamp;
        private String fun;
        private String jid;
        @SerializedName(value="return")
        private JsonElement result;
        private String user;
        private boolean success = false;

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getFun() {
            return this.fun;
        }

        public String getJid() {
            return this.jid;
        }

        public String getUser() {
            return this.user;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Object getResult() {
            return GSON.fromJson(this.result, Object.class);
        }

        public <R> R getResult(Class<R> dataType) {
            return (R)GSON.fromJson(this.result, dataType);
        }

        public <R> R getResult(TypeToken<R> dataType) {
            return (R)GSON.fromJson(this.result, dataType.getType());
        }
    }
}

