/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.utils;

import com.surenpi.jenkins.phoenix.model.XmlNodeResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class XmlUtils {
    public static Map<String, XmlNodeResult> parse(InputStream input, Map<String, String> nodeMap) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(input);
        HashMap<String, XmlNodeResult> resultMap = new HashMap<String, XmlNodeResult>();
        for (String node : nodeMap.keySet()) {
            String xpath = nodeMap.get(node);
            Element ele = (Element)doc.selectSingleNode(xpath);
            if (ele == null) continue;
            XmlNodeResult result = XmlUtils.parse(ele);
            result.setXpath(xpath);
            resultMap.put(node, result);
        }
        return resultMap;
    }

    public static Map<String, XmlNodeResult> parse(File xmlFile, Map<String, String> nodeMap) throws DocumentException, IOException {
        try (FileInputStream input = new FileInputStream(xmlFile);){
            Map<String, XmlNodeResult> map = XmlUtils.parse(input, nodeMap);
            return map;
        }
    }

    public static XmlNodeResult parse(Element ele) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        List attributes = ele.attributes();
        if (attributes != null) {
            for (Object a : attributes) {
                if (!(a instanceof Attribute)) continue;
                Attribute attr = (Attribute)a;
                attrMap.put(attr.getName(), attr.getValue());
            }
        }
        XmlNodeResult xmlNodeResult = new XmlNodeResult();
        xmlNodeResult.setText(ele.getText() != null ? ele.getText().trim() : "");
        xmlNodeResult.setAttrMap(attrMap);
        return xmlNodeResult;
    }
}

