/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import com.surenpi.jenkins.phoenix.model.XmlNodeResult;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class WriteXmlStep
extends Step
implements Serializable {
    private final String xmlFile;
    private final Map<String, XmlNodeResult> nodeMap;

    @DataBoundConstructor
    public WriteXmlStep(String xmlFile, Map<String, XmlNodeResult> nodeMap) {
        this.xmlFile = xmlFile;
        this.nodeMap = nodeMap;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public Map<String, XmlNodeResult> getNodeMap() {
        return this.nodeMap;
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        WriteXmlStep writeXmlStep;

        protected Execution(WriteXmlStep writeXmlStep, @Nonnull StepContext context) {
            super(context);
            this.writeXmlStep = writeXmlStep;
        }

        protected Void run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            FilePath xmlPath = ws.child(this.writeXmlStep.getXmlFile());
            if (xmlPath.isDirectory() || !xmlPath.exists() || this.writeXmlStep.getNodeMap() == null) {
                return null;
            }
            SAXReader reader = new SAXReader();
            Document doc = reader.read(xmlPath.read());
            for (String key : this.writeXmlStep.getNodeMap().keySet()) {
                XmlNodeResult node = this.writeXmlStep.getNodeMap().get(key);
                Element ele = (Element)doc.selectSingleNode(node.getXpath());
                ele.setText(node.getText());
                for (String attr : node.getAttrMap().keySet()) {
                    ele.addAttribute(attr, node.getAttrMap().get(attr));
                }
            }
            try (OutputStream output = xmlPath.write();){
                XMLWriter writer = new XMLWriter(output);
                writer.write(doc);
            }
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String getFunctionName() {
            return "writeXml";
        }
    }
}

