/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import hudson.Extension;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class WritePropertiesStep
extends Step
implements Serializable {
    private final String file;
    private final Object data;

    @DataBoundConstructor
    public WritePropertiesStep(String file, Object data) {
        this.file = file;
        this.data = data;
        if (file == null || "".equals(file.trim())) {
            throw new IllegalArgumentException("file parameter must be provided to modifyProperties");
        }
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getFile() {
        return this.file;
    }

    public Object getData() {
        return this.data;
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private final WritePropertiesStep modifyPropertiesStep;
        private final StepContext stepContext;

        public Execution(WritePropertiesStep modifyPropertiesStep, StepContext stepContext) {
            this.modifyPropertiesStep = modifyPropertiesStep;
            this.stepContext = stepContext;
        }

        public boolean start() throws Exception {
            Object proData = this.modifyPropertiesStep.data;
            File file = new File(this.modifyPropertiesStep.file);
            if (proData instanceof Map) {
                Throwable throwable;
                Properties pro = new Properties();
                if (file.exists()) {
                    try {
                        throwable = null;
                        try (FileInputStream input = new FileInputStream(file);){
                            pro.load(input);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        this.stepContext.onFailure((Throwable)e);
                        throw e;
                    }
                }
                pro.putAll((Map<?, ?>)((Map)proData));
                try {
                    throwable = null;
                    try (FileOutputStream output = new FileOutputStream(file);){
                        pro.store(output, "");
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    this.stepContext.onFailure((Throwable)e);
                    throw e;
                }
                this.stepContext.onSuccess((Object)"success");
            }
            return true;
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String getFunctionName() {
            return "writeProperties";
        }
    }
}

