/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.google.common.collect.ImmutableSet;
import com.surenpi.jenkins.phoenix.steps.WithSCMExecution;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class WithSCMStep
extends Step
implements Serializable {
    private final SCM scm;

    @DataBoundConstructor
    public WithSCMStep(SCM scm) {
        this.scm = scm;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new WithSCMExecution(context, this);
    }

    public SCM getScm() {
        return this.scm;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class, Launcher.class, EnvVars.class, Run.class);
        }

        public String getFunctionName() {
            return "withSCM";
        }

        public ListBoxModel doFillCredentialsIdItems() {
            FreeStyleProject project = new FreeStyleProject(Jenkins.getInstance(), "fake-" + UUID.randomUUID().toString());
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (Item)project, StandardUsernameCredentials.class, new ArrayList(), CredentialsMatchers.withScopes((CredentialsScope[])new CredentialsScope[]{CredentialsScope.GLOBAL}));
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }
    }
}

