/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import com.surenpi.jenkins.phoenix.steps.WithSCMStep;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.slaves.WorkspaceList;
import java.io.File;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

class WithSCMExecution
extends StepExecution {
    private final WithSCMStep withSCMStep;
    private final FilePath ws;

    public WithSCMExecution(StepContext context, WithSCMStep withSCMStep) throws IOException, InterruptedException {
        super(context);
        this.withSCMStep = withSCMStep;
        this.ws = (FilePath)this.getContext().get(FilePath.class);
    }

    public boolean start() throws Exception {
        FilePath tempBinDir = WorkspaceList.tempDir((FilePath)this.ws);
        this.scmCheckout(tempBinDir);
        this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new SCMCallback(tempBinDir)).start();
        return false;
    }

    private void scmCheckout(FilePath tempBinDir) throws IOException, InterruptedException {
        SCM scm = this.withSCMStep.getScm();
        Run run = (Run)this.getContext().get(Run.class);
        SCMRevisionState baseline = null;
        File changelogFile = null;
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
        scm.checkout(run, launcher, tempBinDir, taskListener, changelogFile, baseline);
    }

    class SCMCallback
    extends BodyExecutionCallback.TailCall {
        private final FilePath tempBinDir;

        public SCMCallback(FilePath tempBinDir) {
            this.tempBinDir = tempBinDir;
        }

        protected void finished(StepContext context) throws Exception {
            this.tempBinDir.deleteRecursive();
        }
    }
}

