/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import com.surenpi.jenkins.phoenix.model.XmlNodeResult;
import com.surenpi.jenkins.phoenix.utils.XmlUtils;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ReadXmlStep
extends Step
implements Serializable {
    private static final String SUREN_PKG = "com.surenpi.jenkins.phoenix.model";
    private final String xmlFile;
    private final Map<String, String> nodeMap;

    @DataBoundConstructor
    public ReadXmlStep(String xmlFile, Map<String, String> nodeMap) {
        this.xmlFile = xmlFile;
        this.nodeMap = nodeMap;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public Map<String, String> getNodeMap() {
        return this.nodeMap;
    }

    @Extension
    public static class WhiteLister
    extends Whitelist {
        public boolean permitsMethod(Method method, Object receiver, Object[] args) {
            if (receiver == null) {
                return false;
            }
            Class<?> aClass = receiver.getClass();
            Package aPackage = aClass.getPackage();
            if (aPackage == null) {
                return false;
            }
            String name = aPackage.getName();
            return name.equals(ReadXmlStep.SUREN_PKG) && (method.getName().startsWith("set") || method.getName().startsWith("get") || method.getName().startsWith("add") || method.getName().startsWith("find"));
        }

        public boolean permitsConstructor(@Nonnull Constructor<?> constructor, @Nonnull Object[] args) {
            if (constructor == null) {
                return false;
            }
            Package aPackage = constructor.getDeclaringClass().getPackage();
            if (aPackage == null) {
                return false;
            }
            return aPackage.getName().equals(ReadXmlStep.SUREN_PKG);
        }

        public boolean permitsStaticMethod(@Nonnull Method method, @Nonnull Object[] args) {
            return false;
        }

        public boolean permitsFieldGet(@Nonnull Field field, @Nonnull Object receiver) {
            if (receiver == null) {
                return false;
            }
            Package aPackage = receiver.getClass().getPackage();
            if (aPackage == null) {
                return false;
            }
            return aPackage.getName().equals(ReadXmlStep.SUREN_PKG);
        }

        public boolean permitsFieldSet(@Nonnull Field field, @Nonnull Object receiver, Object value) {
            if (receiver == null) {
                return false;
            }
            Package aPackage = receiver.getClass().getPackage();
            if (aPackage == null) {
                return false;
            }
            return aPackage.getName().equals(ReadXmlStep.SUREN_PKG);
        }

        public boolean permitsStaticFieldGet(@Nonnull Field field) {
            return false;
        }

        public boolean permitsStaticFieldSet(@Nonnull Field field, Object value) {
            return false;
        }
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution {
        private final ReadXmlStep readXmlStep;

        public Execution(@Nonnull ReadXmlStep readXmlStep, @Nonnull StepContext context) {
            super(context);
            this.readXmlStep = readXmlStep;
        }

        protected Object run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            PrintStream logger = ((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
            FilePath xmlPath = ws.child(this.readXmlStep.getXmlFile());
            logger.println(xmlPath);
            if (xmlPath.isDirectory() || !xmlPath.exists() || this.readXmlStep.getNodeMap() == null) {
                return null;
            }
            try (InputStream input = xmlPath.read();){
                Map<String, XmlNodeResult> map = XmlUtils.parse(input, this.readXmlStep.getNodeMap());
                return map;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String getFunctionName() {
            return "readXml";
        }
    }
}

