/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.surenpi.jenkins.phoenix.DurableExecution;
import com.surenpi.jenkins.phoenix.DurableStep;
import com.surenpi.jenkins.phoenix.DurableTaskStepDescriptor;
import com.surenpi.jenkins.phoenix.steps.DurableJdbcTask;
import hudson.Extension;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JdbcStep
extends DurableStep
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(JdbcStep.class.getName());
    private String url;
    private String credentialsId;
    private String sql;
    private String encoding = "utf-8";
    private boolean isText = false;

    @DataBoundConstructor
    public JdbcStep(String url, String credentialsId) {
        this.url = url;
        this.credentialsId = credentialsId;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new DurableExecution(context, this);
    }

    @Override
    public DurableTask task() {
        return new DurableJdbcTask(this);
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getSql() {
        return this.sql;
    }

    @DataBoundSetter
    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean isText() {
        return this.isText;
    }

    @DataBoundSetter
    public void setText(boolean text) {
        this.isText = text;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskStepDescriptor {
        public String getFunctionName() {
            return "jdbc";
        }

        public String getDisplayName() {
            return "JdbcStep";
        }

        public ListBoxModel doFillCredentialsIdItems() {
            FreeStyleProject project = new FreeStyleProject(Jenkins.getInstance(), "fake-" + UUID.randomUUID().toString());
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (Item)project, StandardUsernameCredentials.class, new ArrayList(), CredentialsMatchers.withScopes((CredentialsScope[])new CredentialsScope[]{CredentialsScope.GLOBAL}));
        }
    }
}

