/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.surenpi.jenkins.phoenix.steps.JdbcStep;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.security.ACL;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.DurableTask;

public class DurableJdbcTask
extends DurableTask
implements Serializable {
    private final JdbcStep jdbcStep;

    public DurableJdbcTask(JdbcStep jdbcStep) {
        this.jdbcStep = jdbcStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Controller launch(EnvVars env, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        List allCredentials = CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, new ArrayList());
        Credentials credential = CredentialsMatchers.firstOrNull((Iterable)allCredentials, (CredentialsMatcher)CredentialsMatchers.withId((String)this.jdbcStep.getCredentialsId()));
        if (credential instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCre = (UsernamePasswordCredentials)credential;
            String userName = upCre.getUsername();
            String password = upCre.getPassword().getPlainText();
            try (Reader reader = null;
                 Connection conn = DriverManager.getConnection(this.jdbcStep.getUrl(), userName, password);
                 Statement statement = conn.createStatement();){
                ScriptRunner runner = new ScriptRunner(conn);
                reader = this.jdbcStep.isText() ? new InputStreamReader(new ByteArrayInputStream(this.jdbcStep.getSql().getBytes(this.jdbcStep.getEncoding()))) : new FileReader(new File(this.jdbcStep.getSql()));
                runner.runScript(reader);
            }
        }
        return new JdbcController();
    }

    public void captureOutput() throws UnsupportedOperationException {
    }

    public static class JdbcController
    extends Controller {
        public boolean writeLog(FilePath workspace, OutputStream sink) throws IOException, InterruptedException {
            return true;
        }

        public void cleanup(FilePath workspace) throws IOException, InterruptedException {
        }

        @CheckForNull
        public Integer exitStatus(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            return 0;
        }
    }
}

