/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import com.surenpi.jenkins.phoenix.DurableController;
import com.surenpi.jenkins.phoenix.steps.HttpStep;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.DurableTask;

public class DurableHttpTask
extends DurableTask
implements Serializable {
    private final HttpStep httpStep;

    public DurableHttpTask(HttpStep httpStep) {
        this.httpStep = httpStep;
    }

    public Controller launch(EnvVars env, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException {
        String method = this.httpStep.getMethod();
        CloseableHttpClient client = HttpClients.createDefault();
        Object request = null;
        URI uri = null;
        try {
            String url = this.httpStep.getUrl().replace(" ", "%20");
            uri = new URL(url).toURI();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new IOException("build http url error.", e);
        }
        request = "post".equalsIgnoreCase(method) ? new HttpPost(uri) : new HttpGet(uri);
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (StringUtils.isNotBlank((String)this.httpStep.getResponseBody()) && statusCode == 200) {
            HttpEntity entity = response.getEntity();
            FilePath file = new FilePath(workspace, this.httpStep.getResponseBody());
            try (InputStream input = entity.getContent();){
                file.copyFrom(input);
                listener.getLogger().println("write response file done.");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            listener.getLogger().println(String.format("statusCode is %d", statusCode));
        }
        return new DurableController();
    }
}

