/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.surenpi.jenkins.phoenix.DurableController;
import com.surenpi.jenkins.phoenix.steps.FtpStep;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.security.ACL;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.DurableTask;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpProtocolException;

public class DurableFtpTask
extends DurableTask
implements Serializable {
    private FtpStep ftpStep;

    public DurableFtpTask(FtpStep ftpStep) {
        this.ftpStep = ftpStep;
    }

    public Controller launch(EnvVars env, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        try {
            this.publish(logger);
        }
        catch (IOException e) {
            logger.println(e.getMessage());
        }
        catch (FtpProtocolException e) {
            logger.println(e.getMessage());
        }
        return new DurableController();
    }

    public void captureOutput() throws UnsupportedOperationException {
    }

    public void publish(PrintStream logger) throws IOException, FtpProtocolException {
        FtpClient client = FtpClient.create();
        InetSocketAddress addr = new InetSocketAddress(this.ftpStep.getServerHost(), this.ftpStep.getServerPort());
        client.connect(addr);
        List allCredentials = CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, new ArrayList());
        Credentials credential = CredentialsMatchers.firstOrNull((Iterable)allCredentials, (CredentialsMatcher)CredentialsMatchers.withId((String)this.ftpStep.getCredentialsId()));
        if (credential instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCre = (UsernamePasswordCredentials)credential;
            String userName = upCre.getUsername();
            String password = upCre.getPassword().getPlainText();
            client.login(userName, password.toCharArray());
            client.changeDirectory(this.ftpStep.getTargetDir());
            File srcFile = new File(this.ftpStep.getSrcFile());
            try (FileInputStream fis = new FileInputStream(srcFile);){
                client.putFile(srcFile.getName(), fis, true);
            }
        } else {
            logger.println("only support user password credential.");
        }
    }
}

