/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import hudson.Extension;
import hudson.model.TaskListener;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DiskStep
extends Step {
    private String root = "/";
    private long threshold;

    @DataBoundConstructor
    public DiskStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public long getThreshold() {
        return this.threshold;
    }

    @DataBoundSetter
    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public String getRoot() {
        return this.root;
    }

    @DataBoundSetter
    public void setRoot(String root) {
        this.root = root;
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private final DiskStep diskStep;
        private final StepContext stepContext;

        public Execution(DiskStep diskStep, StepContext stepContext) {
            this.diskStep = diskStep;
            this.stepContext = stepContext;
        }

        public boolean start() throws Exception {
            long free = new File(this.diskStep.getRoot()).getFreeSpace();
            PrintStream logger = ((TaskListener)this.stepContext.get(TaskListener.class)).getLogger();
            logger.println("free: " + free + "; threshold: " + this.diskStep.getThreshold());
            if (free > this.diskStep.getThreshold()) {
                this.stepContext.onSuccess((Object)"success");
            } else {
                this.stepContext.onFailure((Throwable)new RuntimeException("failure"));
            }
            return true;
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String getFunctionName() {
            return "disk";
        }

        @Nonnull
        public String getDisplayName() {
            return "Disk Threshold";
        }
    }
}

