/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix.steps;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CopyStep
extends Builder
implements SimpleBuildStep {
    private String srcFile;
    private String dstFile;
    private boolean keepMeta = false;
    private boolean recursive = false;

    @DataBoundConstructor
    public CopyStep() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Jenkins jenkins = Jenkins.getInstance();
        if (run instanceof WorkflowRun) {
            WorkflowRun wf = (WorkflowRun)run;
            WorkflowJob job = (WorkflowJob)wf.getParent();
            File jobBuildDir = jenkins.getBuildDirFor((Job)job);
            int number = wf.getNumber();
            File sourceFile = new File(jobBuildDir, String.format("%d/%s", number, this.srcFile));
            FilePath sourcePath = new FilePath(sourceFile);
            FilePath targetPath = new FilePath(workspace, this.dstFile);
            if (this.keepMeta) {
                sourcePath.copyToWithPermission(targetPath);
            } else if (this.recursive) {
                sourcePath.copyRecursiveTo(targetPath);
            } else {
                sourcePath.copyTo(targetPath);
            }
        }
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    @DataBoundSetter
    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public String getDstFile() {
        return this.dstFile;
    }

    @DataBoundSetter
    public void setDstFile(String dstFile) {
        this.dstFile = dstFile;
    }

    public boolean isKeepMeta() {
        return this.keepMeta;
    }

    @DataBoundSetter
    public void setKeepMeta(boolean keepMeta) {
        this.keepMeta = keepMeta;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @DataBoundSetter
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Extension
    @Symbol(value={"copy"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

