/*
 * Decompiled with CFR 0.152.
 */
package com.surenpi.jenkins.phoenix;

import com.surenpi.jenkins.phoenix.DurableStep;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.DaemonThreadFactory;
import hudson.util.LogTaskListener;
import hudson.util.NamingThreadFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.util.Timer;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.concurrent.Timeout;
import org.jenkinsci.plugins.workflow.support.concurrent.WithThreadName;

public class DurableExecution
extends AbstractStepExecutionImpl
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(DurableExecution.class.getName());
    private static final long MIN_RECURRENCE_PERIOD = 250L;
    private static final long MAX_RECURRENCE_PERIOD = 15000L;
    private static final float RECURRENCE_PERIOD_BACKOFF = 1.2f;
    private static final ScheduledThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(25, (ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), DurableExecution.class.getName()));
    private final transient DurableStep step;
    private transient FilePath ws;
    private transient long recurrencePeriod;
    private volatile transient ScheduledFuture<?> task;
    private volatile transient ScheduledFuture<?> stopTask;
    private transient boolean printedCannotContactMessage;
    private Controller controller;
    private String node;
    private String remote;
    private boolean returnStdout;
    private String encoding;
    private boolean returnStatus;
    private static final long serialVersionUID = 1L;

    public DurableExecution(StepContext context, DurableStep step) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        this.returnStdout = false;
        this.encoding = "utf-8";
        this.returnStatus = false;
        StepContext context = this.getContext();
        this.ws = (FilePath)context.get(FilePath.class);
        this.node = FilePathUtils.getNodeName((FilePath)this.ws);
        DurableTask durableTask = this.step.task();
        if (this.returnStdout) {
            durableTask.captureOutput();
        }
        this.controller = durableTask.launch((EnvVars)context.get(EnvVars.class), this.ws, (Launcher)context.get(Launcher.class), (TaskListener)context.get(TaskListener.class));
        this.remote = this.ws.getRemote();
        this.setupTimer();
        return false;
    }

    @CheckForNull
    private FilePath getWorkspace() throws AbortException {
        if (this.ws == null) {
            this.ws = FilePathUtils.find((String)this.node, (String)this.remote);
            if (this.ws == null) {
                LOGGER.log(Level.FINE, "Jenkins is not running, no such node {0}, or it is offline", this.node);
                return null;
            }
        }
        try {
            if (!this.ws.exists()) {
                this.ws.mkdirs();
            }
            LOGGER.log(Level.FINE, this.ws.getBaseName() + "==" + this.ws.getName() + "===" + this.ws.getRemote() + "==" + this.ws.isDirectory());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean directory = true;
        try (Timeout timeout = Timeout.limit((long)10L, (TimeUnit)TimeUnit.SECONDS);){
            directory = this.ws.isDirectory();
        }
        catch (Exception x) {
            LOGGER.log(Level.FINE, this.node + " is evidently offline now", x);
            this.ws = null;
            if (!this.printedCannotContactMessage) {
                this.logger().println("Cannot contact " + this.node + ": " + x);
                this.printedCannotContactMessage = true;
            }
            return null;
        }
        if (!directory) {
            throw new AbortException("missing workspace " + this.remote + " on " + this.node);
        }
        return this.ws;
    }

    @Nonnull
    private PrintStream logger() {
        TaskListener l;
        StepContext context = this.getContext();
        try {
            l = (TaskListener)context.get(TaskListener.class);
            if (l != null) {
                LOGGER.log(Level.FINEST, "JENKINS-34021: DurableTaskStep.Execution.listener present in {0}", context);
            } else {
                LOGGER.log(Level.WARNING, "JENKINS-34021: TaskListener not available upon request in {0}", context);
                l = new LogTaskListener(LOGGER, Level.FINE);
            }
        }
        catch (Exception x) {
            LOGGER.log(Level.FINE, "JENKINS-34021: could not get TaskListener in " + context, x);
            l = new LogTaskListener(LOGGER, Level.FINE);
            this.recurrencePeriod = 0L;
        }
        return l.getLogger();
    }

    @Nonnull
    private Launcher launcher() throws IOException, InterruptedException {
        StepContext context = this.getContext();
        Launcher l = (Launcher)context.get(Launcher.class);
        if (l == null) {
            throw new IOException("JENKINS-37486: Launcher not present in " + context);
        }
        return l;
    }

    public void stop(final Throwable cause) throws Exception {
        FilePath workspace = this.getWorkspace();
        if (workspace != null) {
            this.logger().println("Sending interrupt signal to process");
            LOGGER.log(Level.FINE, "stopping process", cause);
            this.stopTask = Timer.get().schedule(new Runnable(){

                @Override
                public void run() {
                    DurableExecution.this.stopTask = null;
                    if (DurableExecution.this.recurrencePeriod > 0L) {
                        DurableExecution.this.recurrencePeriod = 0L;
                        DurableExecution.this.logger().println("After 10s process did not stop");
                        DurableExecution.this.getContext().onFailure(cause);
                    }
                }
            }, 10L, TimeUnit.SECONDS);
            this.controller.stop(workspace, this.launcher());
        } else {
            this.logger().println("Could not connect to " + this.node + " to send interrupt signal to process");
            this.recurrencePeriod = 0L;
            super.stop(cause);
        }
    }

    public String getStatus() {
        StringBuilder b = new StringBuilder();
        try (Timeout timeout = Timeout.limit((long)2L, (TimeUnit)TimeUnit.SECONDS);){
            FilePath workspace = this.getWorkspace();
            if (workspace != null) {
                b.append(this.controller.getDiagnostics(workspace, this.launcher()));
            } else {
                b.append("waiting to reconnect to ").append(this.remote).append(" on ").append(this.node);
            }
        }
        catch (IOException | InterruptedException x) {
            b.append("failed to look up workspace ").append(this.remote).append(" on ").append(this.node).append(": ").append(x);
        }
        b.append("; recurrence period: ").append(this.recurrencePeriod).append("ms");
        ScheduledFuture<?> t = this.task;
        if (t != null) {
            b.append("; check task scheduled; cancelled? ").append(t.isCancelled()).append(" done? ").append(t.isDone());
        }
        if ((t = this.stopTask) != null) {
            b.append("; stop task scheduled; cancelled? ").append(t.isCancelled()).append(" done? ").append(t.isDone());
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.task = null;
        try (WithThreadName naming = new WithThreadName(": checking " + this.remote + " on " + this.node);){
            this.check();
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        finally {
            if (this.recurrencePeriod > 0L) {
                this.task = THREAD_POOL.schedule(this, this.recurrencePeriod, TimeUnit.MILLISECONDS);
            }
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="silly rule")
    private void check() {
        block26: {
            FilePath workspace;
            if (this.recurrencePeriod == 0L) {
                return;
            }
            try {
                workspace = this.getWorkspace();
            }
            catch (AbortException x) {
                this.recurrencePeriod = 0L;
                this.getContext().onFailure((Throwable)x);
                return;
            }
            if (workspace == null) {
                return;
            }
            try (Timeout timeout = Timeout.limit((long)10L, (TimeUnit)TimeUnit.SECONDS);){
                if (this.controller.writeLog(workspace, (OutputStream)this.logger())) {
                    this.getContext().saveState();
                    this.recurrencePeriod = 250L;
                } else {
                    this.recurrencePeriod = Math.min((long)((float)this.recurrencePeriod * 1.2f), 15000L);
                }
                Integer exitCode = this.controller.exitStatus(workspace, this.launcher());
                if (exitCode == null) {
                    LOGGER.log(Level.FINE, "still running in {0} on {1}", new Object[]{this.remote, this.node});
                } else {
                    if (this.controller.writeLog(workspace, (OutputStream)this.logger())) {
                        LOGGER.log(Level.FINE, "last-minute output in {0} on {1}", new Object[]{this.remote, this.node});
                    }
                    if (this.returnStatus || exitCode == 0) {
                        this.getContext().onSuccess(this.returnStatus ? exitCode : (this.returnStdout ? new String(this.controller.getOutput(workspace, this.launcher()), this.encoding) : null));
                    } else {
                        if (this.returnStdout) {
                            this.logger().write(this.controller.getOutput(workspace, this.launcher()));
                        }
                        this.getContext().onFailure((Throwable)new AbortException("script returned exit code " + exitCode));
                    }
                    this.recurrencePeriod = 0L;
                    this.controller.cleanup(workspace);
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, "could not check " + workspace, x);
                this.ws = null;
                if (this.printedCannotContactMessage) break block26;
                this.logger().println("Cannot contact " + this.node + ": " + x);
                this.printedCannotContactMessage = true;
            }
        }
    }

    public void onResume() {
        this.setupTimer();
    }

    private void setupTimer() {
        this.recurrencePeriod = 250L;
        this.task = THREAD_POOL.schedule(this, this.recurrencePeriod, TimeUnit.MILLISECONDS);
    }

    static {
        THREAD_POOL.setKeepAliveTime(1L, TimeUnit.MINUTES);
        THREAD_POOL.allowCoreThreadTimeOut(true);
    }
}

