/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenManager;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken;
import com.sun.xml.ws.security.opt.api.reference.DirectReference;
import com.sun.xml.ws.security.opt.api.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.api.reference.Reference;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBStructure;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.OctectStreamData;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.incoming.DerivedKeyToken;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedKey;
import com.sun.xml.ws.security.opt.impl.incoming.KerberosBinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.incoming.SAMLAssertion;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken;
import com.sun.xml.ws.security.opt.impl.incoming.StreamWriterData;
import com.sun.xml.ws.security.opt.impl.incoming.X509BinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.secconv.impl.client.DefaultSCTokenConfiguration;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.xml.bind.JAXBElement;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.ietf.jgss.GSSException;

public class KeySelectorImpl
extends KeySelector {
    private static KeySelectorImpl keyResolver = null;
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");

    private KeySelectorImpl() {
    }

    public static KeySelector getInstance() {
        return keyResolver;
    }

    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            if (logger.getLevel() == Level.SEVERE) {
                logger.log(Level.SEVERE, "WSS1317.keyinfo.null");
            }
            throw new KeySelectorException("Null KeyInfo object!");
        }
        try {
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
            boolean isBSP = false;
            if (securityPolicy != null) {
                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
            }
            if (isBSP && list.size() > 1) {
                logger.log(Level.SEVERE, "BSP Violation of R5402: KeyInfo MUST have exactly one child");
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "BSP Violation of R5402: KeyInfo MUST have exactly one child", null);
            }
            boolean isStr = false;
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (xmlStructure instanceof KeyValue) {
                    PublicKey pk = null;
                    try {
                        pk = ((KeyValue)xmlStructure).getPublicKey();
                    }
                    catch (KeyException ke) {
                        throw new KeySelectorException(ke);
                    }
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), pk, false);
                        wssContext.getSecurityEnvironment().validateCertificate(cert, wssContext.getExtraneousProperties());
                    }
                    if (!KeySelectorImpl.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                    return new SimpleKeySelectorResult(pk);
                }
                if (xmlStructure instanceof JAXBStructure) {
                    JAXBElement reference = ((JAXBStructure)xmlStructure).getJAXBElement();
                    if (!KeySelectorImpl.isSecurityTokenReference(reference)) continue;
                    isStr = true;
                    final Key key = KeySelectorImpl.resolve(reference, context, purpose);
                    return new KeySelectorResult(){

                        public Key getKey() {
                            return key;
                        }
                    };
                }
                if (xmlStructure instanceof KeyName) {
                    KeyName keyName = (KeyName)xmlStructure;
                    SecretKey returnKey = wssContext.getSecurityEnvironment().getSecretKey(wssContext.getExtraneousProperties(), keyName.getName(), false);
                    if (returnKey == null) {
                        X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), keyName.getName(), false);
                        if (cert == null || !KeySelectorImpl.algEquals(sm.getAlgorithm(), cert.getPublicKey().getAlgorithm())) continue;
                        return new SimpleKeySelectorResult(cert.getPublicKey());
                    }
                    return new SimpleKeySelectorResult(returnKey);
                }
                if (!(xmlStructure instanceof X509Data)) continue;
                Key key = KeySelectorImpl.resolveX509Data(wssContext, (X509Data)xmlStructure, purpose);
                return new SimpleKeySelectorResult(key);
            }
        }
        catch (KeySelectorException kse) {
            throw kse;
        }
        catch (Exception ex) {
            logger.log(Level.FINEST, "Error occurred while resolving keyinformation" + ex.getMessage());
            throw new KeySelectorException(ex);
        }
        throw new KeySelectorException("No KeyValue element found!");
    }

    private static Key resolve(JAXBElement securityTokenReference, XMLCryptoContext context, KeySelector.Purpose purpose) throws KeySelectorException {
        try {
            JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            boolean isPolicyRecipient = wssContext.getMode() == 3;
            SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
            boolean isBSP = false;
            if (securityPolicy != null) {
                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
            }
            SecurityTokenReference str = (SecurityTokenReference)securityTokenReference.getValue();
            Reference reference = str.getReference();
            Key returnKey = null;
            if (reference instanceof KeyIdentifier) {
                KeyIdentifier keyId = (KeyIdentifier)reference;
                returnKey = KeySelectorImpl.resolveKeyIdentifier(context, keyId.getValueType(), keyId.getReferenceValue(), null, purpose);
            } else if (reference instanceof DirectReference) {
                DirectReference dReference = (DirectReference)reference;
                String wscInstance = ((com.sun.xml.ws.security.opt.impl.reference.DirectReference)dReference).getAttribute(wssContext.getWSSCVersion(wssContext.getSecurityPolicyVersion()), "Instance");
                String uri = dReference.getURI();
                if (isBSP && !uri.startsWith("#")) {
                    throw new XWSSecurityException("Violation of BSP R5204 : When a SECURITY_TOKEN_REFERENCE uses a Direct Reference to an INTERNAL_SECURITY_TOKEN, it MUST use a Shorthand XPointer Reference");
                }
                String valueType = dReference.getValueType();
                if ("http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(valueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(valueType)) {
                    valueType = null;
                }
                returnKey = KeySelectorImpl.resolveDirectReference(context, valueType, uri, purpose);
            } else if (reference instanceof com.sun.xml.ws.security.opt.impl.reference.X509IssuerSerial) {
                com.sun.xml.ws.security.opt.impl.reference.X509IssuerSerial xis = (com.sun.xml.ws.security.opt.impl.reference.X509IssuerSerial)((Object)reference);
                BigInteger serialNumber = xis.getX509SerialNumber();
                String issuerName = xis.getX509IssuerName();
                KeySelectorImpl.resolveIssuerSerial(context, issuerName, serialNumber, xis.getId(), purpose);
            } else {
                logger.log(Level.SEVERE, "WSS1308.unsupported.reference.mechanism");
                KeySelectorException xwsse = new KeySelectorException("Key reference mechanism not supported");
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
            }
            return returnKey;
        }
        catch (XWSSecurityException xwsExp) {
            logger.log(Level.FINEST, "Error occurred while resolvingkey information", xwsExp);
            throw new KeySelectorException(xwsExp);
        }
        catch (Exception ex) {
            logger.log(Level.FINEST, "Error occurred while resolvingkey information", ex);
            throw new KeySelectorException(ex);
        }
    }

    public static Key resolveIssuerSerial(XMLCryptoContext context, String issuerName, BigInteger serialNumber, String strId, KeySelector.Purpose purpose) throws KeySelectorException {
        Key returnKey = null;
        String normalizedIssuerName = RFC2253Parser.normalize(issuerName);
        try {
            JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            MLSPolicy inferredKB = wssContext.getSecurityContext().getInferredKB();
            AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
            x509Binding.setReferenceType("IssuerSerialNumber");
            if (inferredKB == null) {
                wssContext.getSecurityContext().setInferredKB(x509Binding);
            } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
            } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                if (dktBind.getOriginalKeyBinding() == null) {
                    dktBind.setOriginalKeyBinding(x509Binding);
                } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                    dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                }
            }
            if (purpose == KeySelector.Purpose.VERIFY) {
                wssContext.setExtraneousProperty("requester.serial", serialNumber);
                wssContext.setExtraneousProperty("requester.issuername", normalizedIssuerName);
                X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), serialNumber, normalizedIssuerName);
                returnKey = cert.getPublicKey();
                if (strId != null) {
                    byte[] encodedCert = cert.getEncoded();
                    wssContext.getElementCache().put(strId, new OctectStreamData(new String(encodedCert)));
                }
            } else if (purpose == KeySelector.Purpose.SIGN || purpose == KeySelector.Purpose.DECRYPT) {
                returnKey = wssContext.getSecurityEnvironment().getPrivateKey(wssContext.getExtraneousProperties(), serialNumber, normalizedIssuerName);
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINEST, "Error occurred while resolvingkey information", ex);
            throw new KeySelectorException(ex);
        }
        return returnKey;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Key resolveDirectReference(XMLCryptoContext context, String valueType, String uri, KeySelector.Purpose purpose) throws KeySelectorException {
        Key returnKey = null;
        try {
            JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            MLSPolicy inferredKB = wssContext.getSecurityContext().getInferredKB();
            String wsuId = SOAPUtil.getIdFromFragmentRef(uri);
            boolean isSymmetric = false;
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(valueType)) {
                X509BinarySecurityToken token = null;
                token = (X509BinarySecurityToken)KeySelectorImpl.resolveToken(wsuId, context);
                if (token == null) {
                    throw new KeySelectorException("Token with Id " + wsuId + "not found");
                }
                AuthenticationTokenPolicy.X509CertificateBinding x509CertificateBinding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509CertificateBinding.setReferenceType("Direct");
                x509CertificateBinding.setValueType(valueType);
                if (inferredKB == null) {
                    wssContext.getSecurityContext().setInferredKB(x509CertificateBinding);
                    return KeySelectorImpl.resolveX509Token(wssContext, token, purpose, isSymmetric);
                } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                    ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509CertificateBinding);
                    isSymmetric = true;
                    return KeySelectorImpl.resolveX509Token(wssContext, token, purpose, isSymmetric);
                } else {
                    if (!PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) return KeySelectorImpl.resolveX509Token(wssContext, token, purpose, isSymmetric);
                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                    if (dktBind.getOriginalKeyBinding() == null) {
                        dktBind.setOriginalKeyBinding(x509CertificateBinding);
                        return KeySelectorImpl.resolveX509Token(wssContext, token, purpose, isSymmetric);
                    } else {
                        if (!PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) return KeySelectorImpl.resolveX509Token(wssContext, token, purpose, isSymmetric);
                        dktBind.getOriginalKeyBinding().setKeyBinding(x509CertificateBinding);
                        isSymmetric = true;
                    }
                }
                return KeySelectorImpl.resolveX509Token(wssContext, token, purpose, isSymmetric);
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(valueType)) {
                KerberosBinarySecurityToken token = (KerberosBinarySecurityToken)KeySelectorImpl.resolveToken(wsuId, context);
                if (token == null) {
                    throw new KeySelectorException("Token with Id " + wsuId + "not found");
                }
                SymmetricKeyBinding symmetricKeyBinding = new SymmetricKeyBinding();
                AuthenticationTokenPolicy.KerberosTokenBinding ktBinding = new AuthenticationTokenPolicy.KerberosTokenBinding();
                ktBinding.setReferenceType("Direct");
                ktBinding.setValueType(valueType);
                symmetricKeyBinding.setKeyBinding(ktBinding);
                if (inferredKB == null) {
                    wssContext.getSecurityContext().setInferredKB(symmetricKeyBinding);
                    return KeySelectorImpl.resolveKerberosToken(wssContext, token);
                } else {
                    if (!PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) return KeySelectorImpl.resolveKerberosToken(wssContext, token);
                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                    if (dktBind.getOriginalKeyBinding() == null) {
                        dktBind.setOriginalKeyBinding(symmetricKeyBinding);
                        return KeySelectorImpl.resolveKerberosToken(wssContext, token);
                    } else {
                        if (!PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) return KeySelectorImpl.resolveKerberosToken(wssContext, token);
                        dktBind.getOriginalKeyBinding().setKeyBinding(ktBinding);
                        isSymmetric = true;
                    }
                }
                return KeySelectorImpl.resolveKerberosToken(wssContext, token);
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(valueType)) {
                void var10_22;
                EncryptedKey token = (EncryptedKey)KeySelectorImpl.resolveToken(wsuId, context);
                if (token == null) {
                    throw new KeySelectorException("Token with Id " + wsuId + "not found");
                }
                Object var10_19 = null;
                boolean saml = wssContext.getSecurityContext().getIsSAMLKeyBinding();
                if (saml) {
                    AuthenticationTokenPolicy.SAMLAssertionBinding sAMLAssertionBinding = new AuthenticationTokenPolicy.SAMLAssertionBinding();
                } else {
                    SymmetricKeyBinding symkBinding = new SymmetricKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    symkBinding.setKeyBinding(x509Binding);
                    SymmetricKeyBinding symmetricKeyBinding = symkBinding;
                }
                if (inferredKB == null) {
                    wssContext.getSecurityContext().setInferredKB((MLSPolicy)var10_22);
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                    ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding((WSSPolicy)var10_22);
                }
                String algo = wssContext.getAlgorithmSuite().getEncryptionAlgorithm();
                return token.getKey(algo);
            }
            if ("http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(valueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(valueType)) {
                if (wssContext.isClient()) {
                    returnKey = KeySelectorImpl.resolveSCT(wssContext, wsuId, purpose);
                }
                if (returnKey == null) {
                    SecurityContextToken scToken = (SecurityContextToken)KeySelectorImpl.resolveToken(wsuId, context);
                    if (scToken == null) {
                        if (wssContext.isClient()) throw new KeySelectorException("Token with Id " + wsuId + "not found");
                        returnKey = KeySelectorImpl.resolveSCT(wssContext, wsuId, purpose);
                    } else {
                        returnKey = KeySelectorImpl.resolveSCT(wssContext, scToken.getSCId(), purpose);
                    }
                }
                SecureConversationTokenKeyBinding sctBinding = new SecureConversationTokenKeyBinding();
                if (inferredKB == null) {
                    wssContext.getSecurityContext().setInferredKB(sctBinding);
                    return returnKey;
                } else {
                    if (!PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) return returnKey;
                    ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                }
                return returnKey;
            }
            if ("http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(valueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(valueType)) {
                DerivedKeyToken token = (DerivedKeyToken)KeySelectorImpl.resolveToken(wsuId, context);
                if (token == null) {
                    throw new KeySelectorException("Token with Id " + wsuId + "not found");
                }
                DerivedTokenKeyBinding derivedTokenKeyBinding = new DerivedTokenKeyBinding();
                derivedTokenKeyBinding.setOriginalKeyBinding(token.getInferredKB());
                if (inferredKB == null) {
                    wssContext.getSecurityContext().setInferredKB(derivedTokenKeyBinding);
                    return token.getKey();
                } else if (!PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) return token.getKey();
                return token.getKey();
            }
            if (null == valueType) {
                SecurityHeaderElement token = KeySelectorImpl.resolveToken(wsuId, context);
                if (token == null) {
                    throw new KeySelectorException("Token with Id " + wsuId + "not found");
                }
                if (token instanceof X509BinarySecurityToken) {
                    AuthenticationTokenPolicy.X509CertificateBinding x509CertificateBinding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509CertificateBinding.setReferenceType("Direct");
                    if (inferredKB == null) {
                        wssContext.getSecurityContext().setInferredKB(x509CertificateBinding);
                        return KeySelectorImpl.resolveX509Token(wssContext, (X509BinarySecurityToken)token, purpose, isSymmetric);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                        ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509CertificateBinding);
                        return KeySelectorImpl.resolveX509Token(wssContext, (X509BinarySecurityToken)token, purpose, isSymmetric);
                    } else {
                        if (!PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) return KeySelectorImpl.resolveX509Token(wssContext, (X509BinarySecurityToken)token, purpose, isSymmetric);
                        DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                        if (dktBind.getOriginalKeyBinding() == null) {
                            dktBind.setOriginalKeyBinding(x509CertificateBinding);
                            return KeySelectorImpl.resolveX509Token(wssContext, (X509BinarySecurityToken)token, purpose, isSymmetric);
                        } else {
                            if (!PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) return KeySelectorImpl.resolveX509Token(wssContext, (X509BinarySecurityToken)token, purpose, isSymmetric);
                            dktBind.getOriginalKeyBinding().setKeyBinding(x509CertificateBinding);
                        }
                    }
                    return KeySelectorImpl.resolveX509Token(wssContext, (X509BinarySecurityToken)token, purpose, isSymmetric);
                }
                if (token instanceof EncryptedKey) {
                    SymmetricKeyBinding symmetricKeyBinding = new SymmetricKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    symmetricKeyBinding.setKeyBinding(x509Binding);
                    if (inferredKB == null) {
                        wssContext.getSecurityContext().setInferredKB(symmetricKeyBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(symmetricKeyBinding);
                    }
                    String algo = wssContext.getAlgorithmSuite().getEncryptionAlgorithm();
                    return ((EncryptedKey)token).getKey(algo);
                }
                if (token instanceof DerivedKeyToken) {
                    DerivedTokenKeyBinding derivedTokenKeyBinding = new DerivedTokenKeyBinding();
                    derivedTokenKeyBinding.setOriginalKeyBinding(((DerivedKeyToken)token).getInferredKB());
                    if (inferredKB == null) {
                        wssContext.getSecurityContext().setInferredKB(derivedTokenKeyBinding);
                        return ((DerivedKeyToken)token).getKey();
                    } else if (!PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) return ((DerivedKeyToken)token).getKey();
                    return ((DerivedKeyToken)token).getKey();
                }
                if (!(token instanceof SecurityContextToken)) return returnKey;
                SecureConversationTokenKeyBinding secureConversationTokenKeyBinding = new SecureConversationTokenKeyBinding();
                if (inferredKB == null) {
                    wssContext.getSecurityContext().setInferredKB(secureConversationTokenKeyBinding);
                    return KeySelectorImpl.resolveSCT(wssContext, ((SecurityContextToken)token).getSCId(), purpose);
                } else {
                    if (!PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) return KeySelectorImpl.resolveSCT(wssContext, ((SecurityContextToken)token).getSCId(), purpose);
                    ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(secureConversationTokenKeyBinding);
                }
                return KeySelectorImpl.resolveSCT(wssContext, ((SecurityContextToken)token).getSCId(), purpose);
            }
            logger.log(Level.SEVERE, "WSS1307.unsupported.directref.mechanism", new Object[]{valueType});
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "unsupported directreference ValueType " + valueType, null);
        }
        catch (XWSSecurityException ex) {
            logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
            throw new KeySelectorException(ex);
        }
        catch (URIReferenceException ex) {
            logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
            throw new KeySelectorException(ex);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Key resolveKeyIdentifier(XMLCryptoContext xc, String valueType, String referenceValue, String strId, KeySelector.Purpose purpose) throws KeySelectorException {
        JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)xc.get("http://wss.sun.com#processingContext");
        Object var6_6 = null;
        MLSPolicy inferredKB = context.getSecurityContext().getInferredKB();
        boolean isSymmetric = false;
        try {
            void var6_18;
            void var6_20;
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(valueType) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier".equals(valueType)) {
                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509Binding.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                x509Binding.setReferenceType("Identifier");
                if (inferredKB == null) {
                    context.getSecurityContext().setInferredKB(x509Binding);
                } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                    ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                    isSymmetric = true;
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                    if (dktBind.getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                        dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                        isSymmetric = true;
                    }
                }
                if (purpose == KeySelector.Purpose.VERIFY || purpose == KeySelector.Purpose.ENCRYPT) {
                    byte[] keyIdBytes = XMLUtil.getDecodedBase64EncodedData(referenceValue);
                    context.setExtraneousProperty("requester.keyid", new String(keyIdBytes));
                    X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), keyIdBytes);
                    if (strId != null) {
                        byte[] encodedCert = cert.getEncoded();
                        context.getElementCache().put(strId, new OctectStreamData(new String(encodedCert)));
                    }
                    if (!isSymmetric && !context.isSamlSignatureKey()) {
                        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                    }
                    PublicKey publicKey = cert.getPublicKey();
                    return var6_20;
                }
                if (purpose != KeySelector.Purpose.SIGN) {
                    if (purpose != KeySelector.Purpose.DECRYPT) return var6_20;
                }
                PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(referenceValue));
                return var6_20;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(valueType)) {
                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509Binding.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
                x509Binding.setReferenceType("Identifier");
                if (inferredKB == null) {
                    context.getSecurityContext().setInferredKB(x509Binding);
                } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                    ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                    isSymmetric = true;
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                    if (dktBind.getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                        dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                        isSymmetric = true;
                    }
                }
                if (purpose == KeySelector.Purpose.VERIFY || purpose == KeySelector.Purpose.ENCRYPT) {
                    byte[] keyIdBytes = XMLUtil.getDecodedBase64EncodedData(referenceValue);
                    context.setExtraneousProperty("requester.keyid", new String(keyIdBytes));
                    X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), keyIdBytes, "Thumbprint");
                    if (!isSymmetric) {
                        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                    }
                    PublicKey publicKey = cert.getPublicKey();
                    if (strId == null) return var6_20;
                    byte[] encodedCert = cert.getEncoded();
                    context.getElementCache().put(strId, new OctectStreamData(new String(encodedCert)));
                    return var6_20;
                }
                if (purpose != KeySelector.Purpose.SIGN) {
                    if (purpose != KeySelector.Purpose.DECRYPT) return var6_20;
                }
                PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(referenceValue), "Thumbprint");
                return var6_20;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(valueType)) {
                SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                AuthenticationTokenPolicy.KerberosTokenBinding ktBinding = new AuthenticationTokenPolicy.KerberosTokenBinding();
                ktBinding.setReferenceType("Identifier");
                skBinding.setKeyBinding(ktBinding);
                if (inferredKB == null) {
                    context.getSecurityContext().setInferredKB(skBinding);
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                    ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                }
                String algo = SecurityUtil.getSecretKeyAlgorithm(context.getAlgorithmSuite().getEncryptionAlgorithm());
                KerberosContext krbContext = context.getKerberosContext();
                if (krbContext == null) throw new XWSSecurityException("SecretKey could not be obtained, Kerberos Context not set");
                String encodedRef = (String)context.getExtraneousProperty("KerbSHA1Value");
                if (!referenceValue.equals(encodedRef)) {
                    throw new XWSSecurityException("SecretKey could not be obtained, Incorrect Kerberos Context found");
                }
                SecretKey secretKey = krbContext.getSecretKey(algo);
                return var6_20;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(valueType)) {
                SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509Binding.setReferenceType("Identifier");
                skBinding.setKeyBinding(x509Binding);
                if (inferredKB == null) {
                    context.getSecurityContext().setInferredKB(skBinding);
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                    ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                }
                String ekSha1RefValue = (String)context.getExtraneousProperty("EncryptedKeySHA1");
                Key secretKey = (Key)context.getExtraneousProperty("SecretKey");
                String keyRefValue = referenceValue;
                if (ekSha1RefValue != null && secretKey != null) {
                    if (!ekSha1RefValue.equals(keyRefValue)) return var6_20;
                    Key key = secretKey;
                    return var6_20;
                }
                String message = "EncryptedKeySHA1 reference not correct";
                logger.log(Level.SEVERE, "WSS1306:unsupported.KeyIdentifier.Reference.Type.encountered", new Object[]{message});
                throw new KeySelectorException(message);
            }
            if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType)) {
                if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType)) return var6_20;
            }
            IssuedTokenKeyBinding itkBinding = new IssuedTokenKeyBinding();
            if (inferredKB == null) {
                if (context.hasIssuedToken()) {
                    context.getSecurityContext().setInferredKB(itkBinding);
                } else {
                    context.getSecurityContext().setInferredKB(new AuthenticationTokenPolicy.SAMLAssertionBinding());
                }
            } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(itkBinding);
            }
            SecurityHeaderElement she = KeySelectorImpl.resolveToken(referenceValue, xc);
            if (she != null && she instanceof SAMLAssertion) {
                SAMLAssertion samlAssertion = (SAMLAssertion)she;
                Key key = samlAssertion.getKey();
                if (strId != null && strId.length() > 0) {
                    SSEData data = new SSEData(samlAssertion, false, context.getNamespaceContext());
                    context.getElementCache().put(strId, data);
                }
            } else {
                HashMap sentSamlKeys = (HashMap)context.getExtraneousProperty("stored_saml_keys");
                if (sentSamlKeys != null) {
                    context.getSecurityContext().setIsSAMLKeyBinding(true);
                    Key key = (Key)sentSamlKeys.get(referenceValue);
                }
            }
            if (!context.hasIssuedToken()) return var6_20;
            if (var6_18 == null) return var6_20;
            SecurityTokenReference str = new SecurityTokenReference(context.getSOAPVersion());
            com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier ki = new com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier(context.getSOAPVersion());
            ki.setValueType(valueType);
            ki.setReferenceValue(referenceValue);
            str.setReference(ki);
            SecurityUtil.initInferredIssuedTokenContext(context, str, (Key)var6_18);
            return var6_20;
        }
        catch (XWSSecurityException ex) {
            logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
            throw new KeySelectorException(ex);
        }
        catch (URIReferenceException ex) {
            logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
            throw new KeySelectorException(ex);
        }
        catch (CertificateEncodingException ex) {
            logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
            throw new KeySelectorException(ex);
        }
    }

    private static boolean algEquals(String algURI, String algName) {
        if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return true;
        }
        return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }

    private static Key resolveX509Token(JAXBFilterProcessingContext context, X509BinarySecurityToken token, KeySelector.Purpose purpose, boolean isSymmetric) throws XWSSecurityException {
        X509Certificate cert = token.getCertificate();
        if (cert == null) {
            cert = SOAPUtil.getCertificateFromToken(token);
        }
        if (purpose == KeySelector.Purpose.VERIFY) {
            if (!isSymmetric) {
                context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
            }
            return cert.getPublicKey();
        }
        if (purpose == KeySelector.Purpose.SIGN || purpose == KeySelector.Purpose.DECRYPT) {
            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
        }
        return null;
    }

    private static Key resolveX509Data(JAXBFilterProcessingContext context, X509Data x509Data, KeySelector.Purpose purpose) throws KeySelectorException {
        X509Certificate cert = null;
        try {
            List<?> data = x509Data.getContent();
            for (Object content : data) {
                if (content instanceof X509Certificate) {
                    cert = (X509Certificate)content;
                } else if (content instanceof byte[]) {
                    byte[] ski = (byte[])content;
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), ski);
                        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                        return cert.getPublicKey();
                    }
                    if (purpose == KeySelector.Purpose.SIGN) {
                        return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), ski);
                    }
                } else {
                    if (content instanceof String) {
                        logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                        throw new KeySelectorException("X509SubjectName child element of X509Data is not yet supported by our implementation");
                    }
                    if (content instanceof X509IssuerSerial) {
                        X509IssuerSerial xis = (X509IssuerSerial)content;
                        if (purpose == KeySelector.Purpose.VERIFY) {
                            cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), xis.getSerialNumber(), xis.getIssuerName());
                            context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                            return cert.getPublicKey();
                        }
                        if (purpose == KeySelector.Purpose.SIGN) {
                            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), xis.getSerialNumber(), xis.getIssuerName());
                        }
                    } else {
                        logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                        throw new KeySelectorException("Unsupported child element of X509Data encountered");
                    }
                }
                if (purpose == KeySelector.Purpose.VERIFY) {
                    context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                    return cert.getPublicKey();
                }
                if (purpose != KeySelector.Purpose.SIGN) continue;
                return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WSS1314.illegal.x509.data", e.getMessage());
            throw new KeySelectorException(e);
        }
        return null;
    }

    protected static SecurityHeaderElement resolveToken(final String uri, XMLCryptoContext context) throws URIReferenceException, XWSSecurityException {
        URIDereferencer resolver = context.getURIDereferencer();
        URIReference uriRef = new URIReference(){

            public String getURI() {
                return uri;
            }

            public String getType() {
                return null;
            }
        };
        JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        try {
            StreamWriterData data = (StreamWriterData)resolver.dereference(uriRef, context);
            if (data == null) {
                return null;
            }
            Object derefData = data.getDereferencedObject();
            SecurityHeaderElement she = null;
            if (derefData instanceof SecurityHeaderElement) {
                she = (SecurityHeaderElement)derefData;
            }
            if (she == null) {
                logger.log(Level.SEVERE, "WSS1304.FC_SECURITY_TOKEN_UNAVAILABLE");
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
            }
            if ("BinarySecurityToken".equals(she.getLocalPart())) {
                BinarySecurityToken token = (BinarySecurityToken)((Object)she);
                if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510".equals(token.getValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(token.getValueType())) {
                    return (KerberosBinarySecurityToken)token;
                }
                X509BinarySecurityToken x509bst = (X509BinarySecurityToken)token;
                X509Certificate cert = null;
                cert = x509bst.getCertificate();
                return x509bst;
            }
            if ("EncryptedKey".equals(she.getLocalPart())) {
                return (EncryptedKey)she;
            }
            if ("SecurityContextToken".equals(she.getLocalPart())) {
                return (SecurityContextToken)she;
            }
            if ("DerivedKeyToken".equals(she.getLocalPart())) {
                return (DerivedKeyToken)she;
            }
            if ("Assertion".equals(she.getLocalPart())) {
                return she;
            }
        }
        catch (URIReferenceException ure) {
            logger.log(Level.SEVERE, "WSS1304.FC_SECURITY_TOKEN_UNAVAILABLE", ure);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", ure);
        }
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "WSS1305.UnSupported.security.token");
        }
        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, "A Unsupported token was provided ", null);
    }

    private static boolean isSecurityTokenReference(JAXBElement reference) {
        String local = reference.getName().getLocalPart();
        String uri = reference.getName().getNamespaceURI();
        return "SecurityTokenReference".equals(local) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(uri);
    }

    private static Key resolveSCT(JAXBFilterProcessingContext wssContext, String scId, KeySelector.Purpose purpose) throws XWSSecurityException {
        Subject subj;
        IssuedTokenContext ctx = null;
        Object itp = null;
        if (wssContext.isClient()) {
            String protocol = wssContext.getWSSCVersion(wssContext.getSecurityPolicyVersion());
            DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(protocol, scId, !wssContext.isExpired(), !wssContext.isInboundMessage());
            ctx = IssuedTokenManager.getInstance().createIssuedTokenContext((IssuedTokenConfiguration)config, null);
            try {
                IssuedTokenManager.getInstance().getIssuedToken(ctx);
            }
            catch (WSTrustException e) {
                throw new XWSSecurityException(e);
            }
            if (ctx == null || ctx.getSecurityPolicy().isEmpty()) {
                return null;
            }
        } else {
            ctx = SessionManager.getSessionManager().getSecurityContext(scId, !wssContext.isExpired());
        }
        if ((subj = ctx.getRequestorSubject()) != null && wssContext.getExtraneousProperty("SCBOOTSTRAP_CRED_IN_SUBJ") == null) {
            wssContext.getSecurityEnvironment().updateOtherPartySubject(SecurityUtil.getSubject(wssContext.getExtraneousProperties()), subj);
            wssContext.getExtraneousProperties().put("SCBOOTSTRAP_CRED_IN_SUBJ", "true");
        }
        byte[] proofKey = null;
        if (wssContext.getWSCInstance() != null) {
            if (wssContext.isExpired()) {
                proofKey = ctx.getProofKey();
            } else {
                SecurityContextTokenInfo sctInstanceInfo = ctx.getSecurityContextTokenInfo();
                proofKey = sctInstanceInfo.getInstanceSecret(wssContext.getWSCInstance());
            }
        } else {
            proofKey = ctx.getProofKey();
        }
        wssContext.setExtraneousProperty("Incoming_SCT", ctx.getSecurityToken());
        if (proofKey == null) {
            throw new XWSSecurityException("Could not locate SecureConversation session for Id:" + scId);
        }
        String algo = "AES";
        if (wssContext.getAlgorithmSuite() != null) {
            algo = SecurityUtil.getSecretKeyAlgorithm(wssContext.getAlgorithmSuite().getEncryptionAlgorithm());
        }
        SecretKeySpec key = new SecretKeySpec(proofKey, algo);
        return key;
    }

    private static Key resolveKerberosToken(JAXBFilterProcessingContext wssContext, KerberosBinarySecurityToken token) throws XWSSecurityException {
        String encodedRef = (String)wssContext.getExtraneousProperty("KerbSHA1Value");
        if (encodedRef == null) {
            try {
                byte[] krbSha1 = MessageDigest.getInstance("SHA-1").digest(token.getTokenValue());
                encodedRef = Base64.encode(krbSha1);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new XWSSecurityException(nsae);
            }
        }
        String algo = SecurityUtil.getSecretKeyAlgorithm(wssContext.getAlgorithmSuite().getEncryptionAlgorithm());
        KerberosContext krbContext = wssContext.getKerberosContext();
        if (krbContext == null) {
            krbContext = wssContext.getSecurityEnvironment().doKerberosLogin(token.getTokenValue());
            wssContext.setKerberosContext(krbContext);
            try {
                wssContext.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(wssContext), krbContext.getGSSContext().getSrcName(), krbContext.getDelegatedCredentials());
            }
            catch (GSSException gsse) {
                throw new XWSSecurityException(gsse);
            }
        }
        wssContext.setExtraneousProperty("KerbSHA1Value", encodedRef);
        return krbContext.getSecretKey(algo);
    }

    static {
        keyResolver = new KeySelectorImpl();
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private Key pk;

        SimpleKeySelectorResult(Key pk) {
            this.pk = pk;
        }

        public Key getKey() {
            return this.pk;
        }
    }
}

