/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.tools.ws.processor.modeler.annotation.TypeMoniker;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class TypeMonikerFactory {
    public static TypeMoniker getTypeMoniker(TypeMirror typeMirror) {
        if (typeMirror == null) {
            throw new NullPointerException();
        }
        if (typeMirror.getKind().isPrimitive()) {
            return new PrimitiveTypeMoniker((PrimitiveType)typeMirror);
        }
        if (typeMirror.getKind().equals((Object)TypeKind.ARRAY)) {
            return new ArrayTypeMoniker((ArrayType)typeMirror);
        }
        if (typeMirror.getKind().equals((Object)TypeKind.DECLARED)) {
            return new DeclaredTypeMoniker((DeclaredType)typeMirror);
        }
        return TypeMonikerFactory.getTypeMoniker(typeMirror.toString());
    }

    public static TypeMoniker getTypeMoniker(String typeName) {
        return new StringMoniker(typeName);
    }

    static class PrimitiveTypeMoniker
    implements TypeMoniker {
        private TypeKind kind;

        public PrimitiveTypeMoniker(PrimitiveType type) {
            this.kind = type.getKind();
        }

        @Override
        public TypeMirror create(ProcessingEnvironment apEnv) {
            return apEnv.getTypeUtils().getPrimitiveType(this.kind);
        }
    }

    static class ArrayTypeMoniker
    implements TypeMoniker {
        private TypeMoniker arrayType;

        public ArrayTypeMoniker(ArrayType type) {
            this.arrayType = TypeMonikerFactory.getTypeMoniker(type.getComponentType());
        }

        @Override
        public TypeMirror create(ProcessingEnvironment apEnv) {
            return apEnv.getTypeUtils().getArrayType(this.arrayType.create(apEnv));
        }
    }

    static class DeclaredTypeMoniker
    implements TypeMoniker {
        private Name typeDeclName;
        private Collection<TypeMoniker> typeArgs = new ArrayList<TypeMoniker>();

        public DeclaredTypeMoniker(DeclaredType type) {
            this.typeDeclName = ((TypeElement)type.asElement()).getQualifiedName();
            for (TypeMirror typeMirror : type.getTypeArguments()) {
                this.typeArgs.add(TypeMonikerFactory.getTypeMoniker(typeMirror));
            }
        }

        @Override
        public TypeMirror create(ProcessingEnvironment apEnv) {
            TypeElement typeDecl = apEnv.getElementUtils().getTypeElement(this.typeDeclName);
            TypeMirror[] tmpArgs = new TypeMirror[this.typeArgs.size()];
            int idx = 0;
            for (TypeMoniker moniker : this.typeArgs) {
                tmpArgs[idx++] = moniker.create(apEnv);
            }
            return apEnv.getTypeUtils().getDeclaredType(typeDecl, tmpArgs);
        }
    }

    static class StringMoniker
    implements TypeMoniker {
        private String typeName;

        public StringMoniker(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public TypeMirror create(ProcessingEnvironment apEnv) {
            return apEnv.getTypeUtils().getDeclaredType(apEnv.getElementUtils().getTypeElement(this.typeName), new TypeMirror[0]);
        }
    }
}

