/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jvnet.wom.Schema;
import org.jvnet.wom.api.WSDLBoundPortType;
import org.jvnet.wom.api.WSDLDefinitions;
import org.jvnet.wom.api.WSDLMessage;
import org.jvnet.wom.api.WSDLPortType;
import org.jvnet.wom.api.WSDLService;
import org.jvnet.wom.api.WSDLSet;
import org.jvnet.wom.api.WSDLTypes;
import org.jvnet.wom.impl.WSDLDefinitionsImpl;
import org.jvnet.wom.impl.util.Iterators;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLSetImpl
implements WSDLSet {
    private final Map<String, WSDLDefinitionsImpl> wsdlMap = new HashMap<String, WSDLDefinitionsImpl>();
    private final List<WSDLDefinitionsImpl> wsdls = new ArrayList<WSDLDefinitionsImpl>();
    private List<WSDLTypes> types = new ArrayList<WSDLTypes>();
    boolean alreadyComputed = false;

    public WSDLDefinitionsImpl createWSDLDefinitions(String name, String targetNamespace, Locator location) {
        WSDLDefinitionsImpl wsdl = this.wsdlMap.get(targetNamespace);
        if (wsdl == null) {
            wsdl = new WSDLDefinitionsImpl(this, location, new QName(targetNamespace, name));
            this.wsdlMap.put(targetNamespace, wsdl);
            this.wsdls.add(wsdl);
        }
        return wsdl;
    }

    void add(WSDLDefinitionsImpl wsdl) {
        this.wsdlMap.put(wsdl.getWSDLDocument().getTargetNamespace(), wsdl);
    }

    @Override
    public WSDLDefinitionsImpl getWSDL(String targetNamespace) {
        return this.wsdlMap.get(targetNamespace);
    }

    @Override
    public Iterator<WSDLDefinitions> getWSDLs() {
        return Collections.unmodifiableCollection(this.wsdlMap.values()).iterator();
    }

    @Override
    public Iterator<WSDLService> services() {
        return new Iterators.Map<WSDLService, WSDLDefinitions>(this.getWSDLs()){

            @Override
            protected Iterator<WSDLService> apply(WSDLDefinitions u) {
                return u.getServices().iterator();
            }
        };
    }

    @Override
    public Iterator<WSDLBoundPortType> boundPortTypes() {
        return new Iterators.Map<WSDLBoundPortType, WSDLDefinitions>(this.getWSDLs()){

            @Override
            protected Iterator<WSDLBoundPortType> apply(WSDLDefinitions u) {
                return u.getBindings().iterator();
            }
        };
    }

    @Override
    public Iterator<WSDLPortType> portTypes() {
        return new Iterators.Map<WSDLPortType, WSDLDefinitions>(this.getWSDLs()){

            @Override
            protected Iterator<WSDLPortType> apply(WSDLDefinitions u) {
                return u.getPortTypes().iterator();
            }
        };
    }

    @Override
    public Iterator<WSDLMessage> messages() {
        return new Iterators.Map<WSDLMessage, WSDLDefinitions>(this.getWSDLs()){

            @Override
            protected Iterator<WSDLMessage> apply(WSDLDefinitions u) {
                return u.getMessages().iterator();
            }
        };
    }

    @Override
    public Iterator<WSDLTypes> types() {
        if (this.alreadyComputed) {
            return this.types.iterator();
        }
        for (WSDLDefinitionsImpl def : this.wsdls) {
            this.types.add(((WSDLDefinitions)def).getWSDLTypes());
        }
        this.alreadyComputed = true;
        return this.types.iterator();
    }

    @Override
    public WSDLService service(QName serviceName) {
        WSDLDefinitions def = this.wsdlMap.get(serviceName.getNamespaceURI());
        return def.getService(serviceName);
    }

    @Override
    public WSDLPortType portType(QName portTypeName) {
        WSDLDefinitions def = this.wsdlMap.get(portTypeName.getNamespaceURI());
        return def.getPortType(portTypeName);
    }

    @Override
    public WSDLBoundPortType boundPortType(QName portType) {
        WSDLDefinitions def = this.wsdlMap.get(portType.getNamespaceURI());
        return def.getBinding(portType);
    }

    @Override
    public WSDLMessage message(QName message) {
        WSDLDefinitions def = this.wsdlMap.get(message.getNamespaceURI());
        return def.getMessage(message);
    }

    @Override
    public WSDLTypes types(String targetNamespace) {
        WSDLDefinitions def = this.wsdlMap.get(targetNamespace);
        return def.getWSDLTypes();
    }

    @Override
    public Object resolveType(QName type) {
        for (WSDLTypes wsdlType : this.types) {
            for (Schema schema : wsdlType.getSchema()) {
                Object obj = schema.resolveType(type);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    @Override
    public Object resolveElement(QName type) {
        while (this.types().hasNext()) {
            WSDLTypes wsdlType = this.types().next();
            for (Schema schema : wsdlType.getSchema()) {
                Object obj = schema.resolveElement(type);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }
}

