/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.util.Pool;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class FiberExecutor {
    private final Tube masterTubeline;
    private final Pool<Tube> tubelinePool;
    private volatile Engine engine;
    private final List<Schedule> schedules = new LinkedList<Schedule>();

    public FiberExecutor(String id, Tube masterTubeline) {
        this.masterTubeline = masterTubeline;
        this.tubelinePool = new Pool.TubePool(masterTubeline);
        this.engine = new Engine(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet runSync(Packet request) {
        Tube tubeline = this.tubelinePool.take();
        try {
            Packet packet = this.engine.createFiber().runSync(tubeline, request);
            return packet;
        }
        finally {
            this.tubelinePool.recycle(tubeline);
        }
    }

    public synchronized void schedule(Packet request, @NotNull Fiber.CompletionCallback callback) {
        this.schedules.add(new Schedule(request, callback));
    }

    public synchronized void startScheduledFibers() {
        Iterator<Schedule> iterator = this.schedules.iterator();
        while (iterator.hasNext()) {
            Schedule schedule = iterator.next();
            iterator.remove();
            this.start(schedule.request, schedule.completionCallback);
        }
    }

    public void start(Packet request, final @NotNull Fiber.CompletionCallback callback) {
        Fiber fiber = this.engine.createFiber();
        final Tube tube = this.tubelinePool.take();
        fiber.start(tube, request, new Fiber.CompletionCallback(){

            public void onCompletion(@NotNull Packet response) {
                FiberExecutor.this.tubelinePool.recycle(tube);
                callback.onCompletion(response);
            }

            public void onCompletion(@NotNull Throwable error) {
                callback.onCompletion(error);
            }
        });
    }

    private static class Schedule {
        private final Packet request;
        private final Fiber.CompletionCallback completionCallback;

        public Schedule(Packet request, Fiber.CompletionCallback completionCallback) {
            this.request = request;
            this.completionCallback = completionCallback;
        }
    }
}

