/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PersistentSequenceData {
    private final String sequenceId;
    private final String boundSecurityTokenReferenceId;
    private final long expirationTime;
    private final Connection sqlConnection;
    private final ResultSet sequenceData;

    public PersistentSequenceData(Connection connection, String sequenceId, String boundSecurityTokenReferenceId, long expirationTime, long lastMessageId, Sequence.Status status, boolean ackRequestedFlag) throws PersistenceException {
        this.sequenceId = sequenceId;
        this.boundSecurityTokenReferenceId = boundSecurityTokenReferenceId;
        this.expirationTime = expirationTime;
        this.sqlConnection = connection;
        try {
            PreparedStatement insertPS = this.sqlConnection.prepareStatement("INSERT INTO RM_SEQUENCES VALUES (?, ?, ?, ?, ?)");
            insertPS.setString(1, sequenceId);
            insertPS.setLong(2, expirationTime);
            insertPS.setInt(3, status.getValue());
            insertPS.setBoolean(4, ackRequestedFlag);
            insertPS.setLong(5, lastMessageId);
            if (insertPS.executeUpdate() != 1) {
                throw new PersistenceException("Sequence data not inserted into database.");
            }
            PreparedStatement queryPS = this.sqlConnection.prepareStatement("SELECT * FROM RM_SEQUENCES WHERE sequence_id = ?");
            queryPS.setString(1, sequenceId);
            this.sequenceData = queryPS.executeQuery();
            if (!this.sequenceData.first()) {
                throw new PersistenceException("Unable to get the sequence data");
            }
        }
        catch (SQLException ex) {
            throw new PersistenceException("Error creating the new sequence data record.", ex);
        }
    }

    public boolean isAckRequestedFlag() {
        try {
            return this.sequenceData.getBoolean("ack_requested_flag");
        }
        catch (SQLException ex) {
            return false;
        }
    }

    public void setAckRequestedFlag(boolean ackRequestedFlag) {
        try {
            this.sequenceData.updateBoolean("ack_requested_flag", ackRequestedFlag);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Sequence.Status getStatus() {
        try {
            return Sequence.Status.valueToStatus(this.sequenceData.getInt("status"));
        }
        catch (SQLException ex) {
            return null;
        }
    }

    public void setStatus(Sequence.Status status) {
        try {
            this.sequenceData.updateInt("status", status.getValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public long getLastMessageId() {
        try {
            return this.sequenceData.getLong("last_message_id");
        }
        catch (SQLException ex) {
            return -1L;
        }
    }

    public long updateLastMessageId(long newId) {
        try {
            long retVal = this.getLastMessageId();
            this.sequenceData.updateLong("last_message_id", newId);
            return retVal;
        }
        catch (SQLException ex) {
            return -1L;
        }
    }

    public long incrementAndGetLastMessageId() {
        try {
            long retVal = this.getLastMessageId() + 1L;
            this.sequenceData.updateLong("last_message_id", retVal);
            return retVal;
        }
        catch (SQLException ex) {
            return -1L;
        }
    }

    public Collection<Long> getAllUnackedIndexes() {
        return null;
    }

    public boolean noUnackedMessageIds() {
        return false;
    }

    public void addUnackedMessageId(long messageId) {
    }

    public boolean removeUnackedMessageId(long messageId) {
        return false;
    }

    public void acquireMessageIdDataReadOnlyLock() {
    }

    public void releaseMessageIdDataReadOnlyLock() {
    }

    public void acquireMessageIdDataReadWriteLock() {
    }

    public void releaseMessageIdDataReadWriteLock() {
    }

    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    public long getLastActivityTime() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateLastActivityTime() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void storeMessage(long id, Object message) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object retrieveMessage(long id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

