/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.policy.spi_impl;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapUpdateProvider;
import com.sun.xml.ws.rx.mc.MakeConnectionSupportedFeature;
import com.sun.xml.ws.rx.policy.assertion.MakeConnectionSupportedAssertion;
import java.util.Arrays;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class RxMapUpdateProvider
implements PolicyMapUpdateProvider {
    private static final Logger LOGGER = Logger.getLogger(RxMapUpdateProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(PolicyMapExtender policyMapMutator, PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        try {
            LOGGER.entering(policyMapMutator, policyMap, model, wsBinding);
            if (policyMapMutator == null) {
                return;
            }
            this.updateMakeConnectionSettings(wsBinding, model, policyMap, policyMapMutator);
        }
        finally {
            LOGGER.exiting();
        }
    }

    private Policy createMakeConnectionPolicy(QName bindingName) {
        return Policy.createPolicy(null, bindingName.getLocalPart() + "_MCSupported_Policy", Arrays.asList(AssertionSet.createAssertionSet(Arrays.asList(new MakeConnectionSupportedAssertion()))));
    }

    private void updateMakeConnectionSettings(WSBinding wsBinding, SEIModel model, PolicyMap policyMap, PolicyMapExtender policyMapMutator) throws PolicyException, IllegalArgumentException {
        Policy existingPolicy;
        MakeConnectionSupportedFeature mcFeature = wsBinding.getFeature(MakeConnectionSupportedFeature.class);
        if (mcFeature == null || !mcFeature.isEnabled()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Make connection feature enabled on service '%s', port '%s'", model.getServiceQName(), model.getPortName()));
        }
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(model.getServiceQName(), model.getPortName());
        Policy policy = existingPolicy = policyMap != null ? policyMap.getEndpointEffectivePolicy(endpointKey) : null;
        if (existingPolicy == null || !existingPolicy.contains(MakeConnectionSupportedAssertion.NAME)) {
            Policy mcPolicy = this.createMakeConnectionPolicy(model.getBoundPortTypeName());
            policyMapMutator.putEndpointSubject(endpointKey, new PolicySubject((Object)model.getBoundPortTypeName(), mcPolicy));
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Added make connection policy with ID '%s' to binding element '%s'", mcPolicy.getIdOrName(), model.getBoundPortTypeName()));
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Make connection assertion is already present in the endpoint policy");
        }
    }
}

