/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing.policy;

import com.sun.xml.ws.addressing.W3CAddressingMetadataConstants;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressingModelConfiguratorProvider
implements ModelConfiguratorProvider {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(AddressingModelConfiguratorProvider.class);
    private static final QName[] ADDRESSING_ASSERTIONS = new QName[]{new QName(AddressingVersion.MEMBER.policyNsUri, "UsingAddressing")};

    @Override
    public Collection<WebServiceFeature> getFeatures(PolicyMapKey key, PolicyMap policyMap) throws PolicyException {
        LOGGER.entering(key, policyMap);
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (key != null && policyMap != null) {
            Policy policy = policyMap.getEndpointEffectivePolicy(key);
            for (QName addressingAssertionQName : ADDRESSING_ASSERTIONS) {
                if (policy == null || !policy.contains(addressingAssertionQName)) continue;
                for (AssertionSet assertionSet : policy) {
                    for (PolicyAssertion assertion : assertionSet) {
                        if (!assertion.getName().equals(addressingAssertionQName)) continue;
                        WebServiceFeature feature = AddressingVersion.getFeature(addressingAssertionQName.getNamespaceURI(), true, !assertion.isOptional());
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Added addressing feature \"" + feature + "\" for element \"" + key + "\"");
                        }
                        features.add(feature);
                    }
                }
            }
            if (policy != null && policy.contains(W3CAddressingMetadataConstants.WSAM_ADDRESSING_ASSERTION)) {
                for (AssertionSet assertions : policy) {
                    for (PolicyAssertion assertion : assertions) {
                        if (!assertion.getName().equals(W3CAddressingMetadataConstants.WSAM_ADDRESSING_ASSERTION)) continue;
                        NestedPolicy nestedPolicy = assertion.getNestedPolicy();
                        boolean requiresAnonymousResponses = false;
                        boolean requiresNonAnonymousResponses = false;
                        if (nestedPolicy != null) {
                            requiresAnonymousResponses = nestedPolicy.contains(W3CAddressingMetadataConstants.WSAM_ANONYMOUS_NESTED_ASSERTION);
                            requiresNonAnonymousResponses = nestedPolicy.contains(W3CAddressingMetadataConstants.WSAM_NONANONYMOUS_NESTED_ASSERTION);
                        }
                        if (requiresAnonymousResponses && requiresNonAnonymousResponses) {
                            throw new WebServiceException("Only one among AnonymousResponses and NonAnonymousResponses can be nested in an Addressing assertion");
                        }
                        AddressingFeature feature = requiresAnonymousResponses ? new AddressingFeature(true, !assertion.isOptional(), AddressingFeature.Responses.ANONYMOUS) : (requiresNonAnonymousResponses ? new AddressingFeature(true, !assertion.isOptional(), AddressingFeature.Responses.NON_ANONYMOUS) : new AddressingFeature(true, !assertion.isOptional()));
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Added addressing feature \"" + feature + "\" for element \"" + key + "\"");
                        }
                        features.add((WebServiceFeature)feature);
                    }
                }
            }
        }
        LOGGER.exiting(features);
        return features;
    }
}

