/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.common.CoordinatorIF;
import com.sun.xml.ws.tx.at.common.WSATVersion;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignRecoveryContextManager {
    private static final int REPLAY_TIMER_INTERVAL_MS = new Integer(System.getProperty("com.sun.xml.ws.tx.at.internal.indoubt.timeout.interval", "10000"));
    private static final int INDOUBT_TIMEOUT = new Integer(System.getProperty("com.sun.xml.ws.tx.at.internal.indoubt.timeout", "90000"));
    private static ForeignRecoveryContextManager singleton = new ForeignRecoveryContextManager();
    private Map<Xid, RecoveryContextWorker> recoveredContexts = new HashMap<Xid, RecoveryContextWorker>();

    private ForeignRecoveryContextManager() {
    }

    public static ForeignRecoveryContextManager getInstance() {
        return singleton;
    }

    public synchronized ForeignRecoveryContext addAndGetForeignRecoveryContextForTidByteArray(Xid xid) {
        RecoveryContextWorker rc = this.recoveredContexts.get(xid);
        if (rc != null) {
            return rc.context;
        }
        ForeignRecoveryContext frc = new ForeignRecoveryContext(xid);
        this.add(frc, false);
        return frc;
    }

    void start() {
        new Thread(new ContextRunnable()).start();
    }

    synchronized void add(ForeignRecoveryContext context) {
        this.add(context, true);
    }

    synchronized void add(ForeignRecoveryContext context, boolean isRecovery) {
        this.recoveredContexts.put(context.getXid(), new RecoveryContextWorker(context, isRecovery ? -1 : 0));
    }

    synchronized void persist(Xid xid) {
    }

    Map<Xid, RecoveryContextWorker> getRecoveredContexts() {
        return this.recoveredContexts;
    }

    synchronized void remove(Xid fxid) {
        this.recoveredContexts.remove(fxid);
    }

    private class RecoveryContextWorker {
        ForeignRecoveryContext context;
        long lastReplayMillis;
        boolean scheduled;
        private int retryCount = 1;

        RecoveryContextWorker(ForeignRecoveryContext context, int lastReplay) {
            this.context = context;
            this.lastReplayMillis = lastReplay;
        }

        synchronized long getLastReplayMillis() {
            return this.lastReplayMillis;
        }

        synchronized void setLastReplayMillis(long lastReplayMillis) {
            this.lastReplayMillis = lastReplayMillis;
        }

        synchronized boolean isScheduled() {
            return this.scheduled;
        }

        synchronized void setScheduled(boolean b) {
            this.scheduled = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Xid xid = this.context.getXid();
                if (xid == null) {
                    return;
                }
                CoordinatorIF coordinatorPort = WSATHelper.getInstance(this.context.getVersion()).getCoordinatorPort(this.context.getEndpointReference(), xid);
                Object notification = WSATVersion.getInstance(this.context.getVersion()).newNotificationBuilder().build();
                Transaction transaction = this.context.getTransaction();
                if (transaction != null && transaction.getStatus() == 2) {
                    coordinatorPort.preparedOperation(notification);
                }
            }
            catch (Throwable throwable) {
                RecoveryContextWorker recoveryContextWorker = this;
                synchronized (recoveryContextWorker) {
                    this.scheduled = false;
                    this.lastReplayMillis = System.currentTimeMillis();
                }
            }
            finally {
                RecoveryContextWorker recoveryContextWorker = this;
                synchronized (recoveryContextWorker) {
                    this.scheduled = false;
                    this.lastReplayMillis = System.currentTimeMillis();
                }
            }
        }

        void incrementRetryCount() {
            if (this.retryCount * 2 * INDOUBT_TIMEOUT < 0x2AAAAAAA) {
                this.retryCount *= 2;
            }
        }

        int getRetryCount() {
            return this.retryCount;
        }
    }

    private class ContextRunnable
    implements Runnable {
        private ContextRunnable() {
        }

        public void run() {
            while (true) {
                this.doRun();
                try {
                    Thread.sleep(300000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() {
            ArrayList<RecoveryContextWorker> replayList = new ArrayList<RecoveryContextWorker>();
            ForeignRecoveryContextManager foreignRecoveryContextManager = ForeignRecoveryContextManager.this;
            synchronized (foreignRecoveryContextManager) {
                for (RecoveryContextWorker rc : ForeignRecoveryContextManager.this.recoveredContexts.values()) {
                    long lastReplay = rc.getLastReplayMillis();
                    if (lastReplay == -1L) {
                        replayList.add(rc);
                        continue;
                    }
                    try {
                        Transaction transaction = rc.context.getTransaction();
                        if (transaction == null || transaction.getStatus() != 2) continue;
                        if (lastReplay == 0L) {
                            rc.setLastReplayMillis(System.currentTimeMillis());
                        }
                        replayList.add(rc);
                    }
                    catch (Throwable e) {}
                }
            }
            for (RecoveryContextWorker rc : replayList) {
                boolean isScheduled = rc.isScheduled();
                if (isScheduled || System.currentTimeMillis() - rc.getLastReplayMillis() <= (long)(INDOUBT_TIMEOUT * rc.getRetryCount())) continue;
                rc.setScheduled(true);
                rc.incrementRetryCount();
            }
        }
    }
}

