/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.servlet;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.transport.Headers;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServletConnectionImpl
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext context;
    private int status;
    private Headers requestHeaders;
    private final HttpAdapter adapter;
    private Headers responseHeaders;
    private static final PropertySet.PropertyMap model = ServletConnectionImpl.parse(ServletConnectionImpl.class);

    public ServletConnectionImpl(@NotNull HttpAdapter adapter, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.adapter = adapter;
        this.context = context;
        this.request = request;
        this.response = response;
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.headers", "com.sun.xml.ws.api.message.packet.inbound.transport.headers"})
    @NotNull
    public Map<String, List<String>> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Headers();
            Enumeration enums = this.request.getHeaderNames();
            while (enums.hasMoreElements()) {
                String headerName = (String)enums.nextElement();
                String headerValue = this.request.getHeader(headerName);
                ArrayList<String> values = (ArrayList<String>)this.requestHeaders.get(headerName);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.requestHeaders.put(headerName, values);
                }
                values.add(headerValue);
            }
        }
        return this.requestHeaders;
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> headers) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new Headers();
        } else {
            this.responseHeaders.clear();
        }
        this.responseHeaders.putAll(headers);
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.response.headers", "com.sun.xml.ws.api.message.packet.outbound.transport.headers"})
    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.response.code"})
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setContentTypeResponseHeader(@NotNull String value) {
        this.response.setContentType(value);
    }

    @Override
    @NotNull
    public InputStream getInput() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    @NotNull
    public OutputStream getOutput() throws IOException {
        this.response.setStatus(this.status);
        if (this.responseHeaders != null) {
            for (Map.Entry entry : this.responseHeaders.entrySet()) {
                String name = (String)entry.getKey();
                if (name.equalsIgnoreCase("Content-Type") || name.equalsIgnoreCase("Content-Length")) continue;
                for (String value : (List)entry.getValue()) {
                    this.response.addHeader(name, value);
                }
            }
        }
        return this.response.getOutputStream();
    }

    @Override
    @NotNull
    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    @Override
    public Principal getUserPrincipal(Packet p) {
        return this.request.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(Packet p, String role) {
        return this.request.isUserInRole(role);
    }

    @Override
    @NotNull
    public String getEPRAddress(Packet p, WSEndpoint endpoint) {
        PortAddressResolver resolver = this.adapter.owner.createPortAddressResolver(this.getBaseAddress());
        String address = resolver.getAddressFor(endpoint.getServiceName(), endpoint.getPortName().getLocalPart());
        if (address == null) {
            throw new WebServiceException(WsservletMessages.SERVLET_NO_ADDRESS_AVAILABLE(endpoint.getPortName()));
        }
        return address;
    }

    @Override
    public String getWSDLAddress(@NotNull Packet request, @NotNull WSEndpoint endpoint) {
        String eprAddress = this.getEPRAddress(request, endpoint);
        if (this.adapter.getEndpoint().getPort() != null) {
            return eprAddress + "?wsdl";
        }
        return null;
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.method"})
    @NotNull
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public boolean isSecure() {
        return this.request.getScheme().equals("https");
    }

    @Override
    public String getRequestHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.querystring"})
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.pathinfo"})
    @NotNull
    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    @Override
    @NotNull
    public String getBaseAddress() {
        return ServletConnectionImpl.getBaseAddress(this.request);
    }

    @NotNull
    static String getBaseAddress(HttpServletRequest request) {
        StringBuilder buf = new StringBuilder();
        buf.append(request.getScheme());
        buf.append("://");
        buf.append(request.getServerName());
        buf.append(':');
        buf.append(request.getServerPort());
        buf.append(request.getContextPath());
        return buf.toString();
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.context"})
    public ServletContext getContext() {
        return this.context;
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.response"})
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.request"})
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @PropertySet.Property(value={"com.sun.xml.ws.transport.http.servlet.requestURL"})
    public String getRequestURL() {
        return this.request.getRequestURL().toString();
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol();
    }

    @Override
    public void setContentLengthResponseHeader(int value) {
        this.response.setContentLength(value);
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

