/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.ExceptionHasMessage;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.server.AbstractServerAsyncTransport;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.Module;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.server.UnsupportedMediaException;
import com.sun.xml.ws.transport.http.HttpAdapterList;
import com.sun.xml.ws.transport.http.HttpMetadataPublisher;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.Pool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAdapter
extends Adapter<HttpToolkit> {
    private Map<String, SDDocument> wsdls;
    private Map<SDDocument, String> revWsdls;
    private ServiceDefinition serviceDefinition = null;
    public final HttpAdapterList<? extends HttpAdapter> owner;
    public final String urlPattern;
    public static CompletionCallback NO_OP_COMPLETION_CALLBACK = new CompletionCallback(){

        public void onCompletion() {
        }
    };
    public static boolean dump = false;
    public static boolean publishStatusPage = true;
    private static final Logger LOGGER;

    public static HttpAdapter createAlone(WSEndpoint endpoint) {
        return new DummyList().createAdapter("", "", endpoint);
    }

    protected HttpAdapter(WSEndpoint endpoint, HttpAdapterList<? extends HttpAdapter> owner) {
        this(endpoint, owner, null);
    }

    protected HttpAdapter(WSEndpoint endpoint, HttpAdapterList<? extends HttpAdapter> owner, String urlPattern) {
        super(endpoint);
        this.owner = owner;
        this.urlPattern = urlPattern;
        this.initWSDLMap(endpoint.getServiceDefinition());
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public void initWSDLMap(ServiceDefinition sdef) {
        this.serviceDefinition = sdef;
        if (sdef == null) {
            this.wsdls = Collections.emptyMap();
            this.revWsdls = Collections.emptyMap();
        } else {
            this.wsdls = new HashMap<String, SDDocument>();
            TreeMap<String, SDDocument> systemIds = new TreeMap<String, SDDocument>();
            for (SDDocument sdd : sdef) {
                if (sdd == sdef.getPrimary()) {
                    this.wsdls.put("wsdl", sdd);
                    this.wsdls.put("WSDL", sdd);
                    continue;
                }
                systemIds.put(sdd.getURL().toString(), sdd);
            }
            int wsdlnum = 1;
            int xsdnum = 1;
            for (Map.Entry entry : systemIds.entrySet()) {
                SDDocument sdd = (SDDocument)entry.getValue();
                if (sdd.isWSDL()) {
                    this.wsdls.put("wsdl=" + wsdlnum++, sdd);
                }
                if (!sdd.isSchema()) continue;
                this.wsdls.put("xsd=" + xsdnum++, sdd);
            }
            this.revWsdls = new HashMap<SDDocument, String>();
            for (Map.Entry<Object, Object> entry : this.wsdls.entrySet()) {
                if (((String)entry.getKey()).equals("WSDL")) continue;
                this.revWsdls.put((SDDocument)entry.getValue(), (String)entry.getKey());
            }
        }
    }

    public String getValidPath() {
        if (this.urlPattern.endsWith("/*")) {
            return this.urlPattern.substring(0, this.urlPattern.length() - 2);
        }
        return this.urlPattern;
    }

    @Override
    protected HttpToolkit createToolkit() {
        return new HttpToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(@NotNull WSHTTPConnection connection) throws IOException {
        if (this.handleGet(connection)) {
            return;
        }
        Pool currentPool = this.getPool();
        HttpToolkit tk = (HttpToolkit)currentPool.take();
        try {
            tk.handle(connection);
        }
        finally {
            currentPool.recycle(tk);
        }
    }

    public boolean handleGet(@NotNull WSHTTPConnection connection) throws IOException {
        if (connection.getRequestMethod().equals("GET")) {
            for (EndpointComponent c : this.endpoint.getComponentRegistry()) {
                HttpMetadataPublisher spi = c.getSPI(HttpMetadataPublisher.class);
                if (spi == null || !spi.handleMetadataRequest(this, connection)) continue;
                return true;
            }
            if (this.isMetadataQuery(connection.getQueryString())) {
                this.publishWSDL(connection);
                return true;
            }
            WSBinding binding = this.getEndpoint().getBinding();
            if (!(binding instanceof HTTPBinding)) {
                this.writeWebServicesHtmlPage(connection);
                return true;
            }
        } else if (connection.getRequestMethod().equals("HEAD")) {
            connection.getInput().close();
            WSBinding binding = this.getEndpoint().getBinding();
            if (this.isMetadataQuery(connection.getQueryString())) {
                SDDocument doc = this.wsdls.get(connection.getQueryString());
                connection.setStatus(doc != null ? 200 : 404);
                connection.getOutput().close();
                connection.close();
                return true;
            }
            if (!(binding instanceof HTTPBinding)) {
                connection.setStatus(404);
                connection.getOutput().close();
                connection.close();
                return true;
            }
        }
        return false;
    }

    private Packet decodePacket(@NotNull WSHTTPConnection con, @NotNull Codec codec) throws IOException {
        String ct = con.getRequestHeader("Content-Type");
        InputStream in = con.getInput();
        Packet packet = new Packet();
        packet.soapAction = this.fixQuotesAroundSoapAction(con.getRequestHeader("SOAPAction"));
        packet.wasTransportSecure = con.isSecure();
        packet.acceptableMimeTypes = con.getRequestHeader("Accept");
        packet.addSatellite(con);
        packet.transportBackChannel = new Oneway(con);
        packet.webServiceContextDelegate = con.getWebServiceContextDelegate();
        if (dump) {
            ByteArrayBuffer buf = new ByteArrayBuffer();
            buf.write(in);
            in.close();
            this.dump(buf, "HTTP request", con.getRequestHeaders());
            in = buf.newInputStream();
        }
        codec.decode(in, ct, packet);
        return packet;
    }

    private String fixQuotesAroundSoapAction(String soapAction) {
        if (!(soapAction == null || soapAction.startsWith("\"") && soapAction.endsWith("\""))) {
            LOGGER.warning("Received WS-I BP non-conformant Unquoted SoapAction HTTP header: " + soapAction);
            String fixedSoapAction = soapAction;
            if (!soapAction.startsWith("\"")) {
                fixedSoapAction = "\"" + fixedSoapAction;
            }
            if (!soapAction.endsWith("\"")) {
                fixedSoapAction = fixedSoapAction + "\"";
            }
            return fixedSoapAction;
        }
        return soapAction;
    }

    private void encodePacket(@NotNull Packet packet, @NotNull WSHTTPConnection con, @NotNull Codec codec) throws IOException {
        if (con.isClosed()) {
            return;
        }
        Message responseMessage = packet.getMessage();
        if (responseMessage == null) {
            if (!con.isClosed()) {
                if (con.getStatus() == 0) {
                    con.setStatus(202);
                }
                try {
                    con.getOutput().close();
                }
                catch (IOException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
        } else {
            ContentType contentType;
            if (con.getStatus() == 0) {
                con.setStatus(responseMessage.isFault() ? 500 : 200);
            }
            if ((contentType = codec.getStaticContentType(packet)) != null) {
                OutputStream os;
                con.setContentTypeResponseHeader(contentType.getContentType());
                OutputStream outputStream = os = con.getProtocol().contains("1.1") ? con.getOutput() : new Http10OutputStream(con);
                if (dump) {
                    ByteArrayBuffer buf = new ByteArrayBuffer();
                    codec.encode(packet, buf);
                    this.dump(buf, "HTTP response " + con.getStatus(), con.getResponseHeaders());
                    buf.writeTo(os);
                } else {
                    codec.encode(packet, os);
                }
                os.close();
            } else {
                ByteArrayBuffer buf = new ByteArrayBuffer();
                contentType = codec.encode(packet, buf);
                con.setContentTypeResponseHeader(contentType.getContentType());
                if (dump) {
                    this.dump(buf, "HTTP response " + con.getStatus(), con.getResponseHeaders());
                }
                OutputStream os = con.getOutput();
                buf.writeTo(os);
                os.close();
            }
        }
    }

    public void invokeAsync(WSHTTPConnection con) throws IOException {
        this.invokeAsync(con, NO_OP_COMPLETION_CALLBACK);
    }

    public void invokeAsync(final WSHTTPConnection con, final CompletionCallback callback) throws IOException {
        Packet request;
        if (this.handleGet(con)) {
            callback.onCompletion();
            return;
        }
        final Pool currentPool = this.getPool();
        final HttpToolkit tk = (HttpToolkit)currentPool.take();
        try {
            request = this.decodePacket(con, tk.codec);
        }
        catch (ExceptionHasMessage e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
            Packet response = new Packet();
            response.setMessage(e.getFaultMessage());
            this.encodePacket(response, con, tk.codec);
            currentPool.recycle(tk);
            con.close();
            callback.onCompletion();
            return;
        }
        catch (UnsupportedMediaException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
            Packet response = new Packet();
            con.setStatus(415);
            this.encodePacket(response, con, tk.codec);
            currentPool.recycle(tk);
            con.close();
            callback.onCompletion();
            return;
        }
        this.endpoint.process(request, new WSEndpoint.CompletionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(@NotNull Packet response) {
                try {
                    try {
                        HttpAdapter.this.encodePacket(response, con, tk.codec);
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.SEVERE, ioe.getMessage(), ioe);
                    }
                    currentPool.recycle(tk);
                }
                finally {
                    con.close();
                    callback.onCompletion();
                }
            }
        }, null);
    }

    private boolean isMetadataQuery(String query) {
        return query != null && (query.equals("WSDL") || query.startsWith("wsdl") || query.startsWith("xsd="));
    }

    public void publishWSDL(@NotNull WSHTTPConnection con) throws IOException {
        con.getInput().close();
        SDDocument doc = this.wsdls.get(con.getQueryString());
        if (doc == null) {
            this.writeNotFoundErrorPage(con, "Invalid Request");
            return;
        }
        con.setStatus(200);
        con.setContentTypeResponseHeader("text/xml;charset=utf-8");
        OutputStream os = con.getProtocol().contains("1.1") ? con.getOutput() : new Http10OutputStream(con);
        PortAddressResolver portAddressResolver = this.owner.createPortAddressResolver(con.getBaseAddress());
        final String address = portAddressResolver.getAddressFor(this.endpoint.getServiceName(), this.endpoint.getPortName().getLocalPart());
        assert (address != null);
        DocumentAddressResolver resolver = new DocumentAddressResolver(){

            public String getRelativeAddressFor(@NotNull SDDocument current, @NotNull SDDocument referenced) {
                assert (HttpAdapter.this.revWsdls.containsKey(referenced));
                return address + '?' + (String)HttpAdapter.this.revWsdls.get(referenced);
            }
        };
        doc.writeTo(portAddressResolver, resolver, os);
        os.close();
    }

    private void writeNotFoundErrorPage(WSHTTPConnection con, String message) throws IOException {
        con.setStatus(404);
        con.setContentTypeResponseHeader("text/html; charset=utf-8");
        PrintWriter out = new PrintWriter(new OutputStreamWriter(con.getOutput(), "UTF-8"));
        out.println("<html>");
        out.println("<head><title>");
        out.println(WsservletMessages.SERVLET_HTML_TITLE());
        out.println("</title></head>");
        out.println("<body>");
        out.println(WsservletMessages.SERVLET_HTML_NOT_FOUND(message));
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    private void writeInternalServerError(WSHTTPConnection con) throws IOException {
        con.setStatus(500);
        con.getOutput().close();
    }

    private void dump(ByteArrayBuffer buf, String caption, Map<String, List<String>> headers) throws IOException {
        System.out.println("---[" + caption + "]---");
        if (headers != null) {
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                if (header.getValue().isEmpty()) {
                    System.out.println(header.getValue());
                    continue;
                }
                for (String value : header.getValue()) {
                    System.out.println(header.getKey() + ": " + value);
                }
            }
        }
        buf.writeTo(System.out);
        System.out.println("--------------------");
    }

    private void writeWebServicesHtmlPage(WSHTTPConnection con) throws IOException {
        if (!publishStatusPage) {
            return;
        }
        con.getInput().close();
        con.setStatus(200);
        con.setContentTypeResponseHeader("text/html; charset=utf-8");
        PrintWriter out = new PrintWriter(new OutputStreamWriter(con.getOutput(), "UTF-8"));
        out.println("<html>");
        out.println("<head><title>");
        out.println(WsservletMessages.SERVLET_HTML_TITLE());
        out.println("</title></head>");
        out.println("<body>");
        out.println(WsservletMessages.SERVLET_HTML_TITLE_2());
        Module module = this.getEndpoint().getContainer().getSPI(Module.class);
        List<Object> endpoints = Collections.emptyList();
        if (module != null) {
            endpoints = module.getBoundEndpoints();
        }
        if (endpoints.isEmpty()) {
            out.println(WsservletMessages.SERVLET_HTML_NO_INFO_AVAILABLE());
        } else {
            out.println("<table width='100%' border='1'>");
            out.println("<tr>");
            out.println("<td>");
            out.println(WsservletMessages.SERVLET_HTML_COLUMN_HEADER_PORT_NAME());
            out.println("</td>");
            out.println("<td>");
            out.println(WsservletMessages.SERVLET_HTML_COLUMN_HEADER_INFORMATION());
            out.println("</td>");
            out.println("</tr>");
            for (BoundEndpoint boundEndpoint : endpoints) {
                String endpointAddress = boundEndpoint.getAddress(con.getBaseAddress()).toString();
                out.println("<tr>");
                out.println("<td>");
                out.println(WsservletMessages.SERVLET_HTML_ENDPOINT_TABLE(boundEndpoint.getEndpoint().getServiceName(), boundEndpoint.getEndpoint().getPortName()));
                out.println("</td>");
                out.println("<td>");
                out.println(WsservletMessages.SERVLET_HTML_INFORMATION_TABLE(endpointAddress, boundEndpoint.getEndpoint().getImplementationClass().getName()));
                out.println("</td>");
                out.println("</tr>");
            }
            out.println("</table>");
        }
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    static {
        try {
            dump = Boolean.getBoolean(HttpAdapter.class.getName() + ".dump");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            publishStatusPage = System.getProperty(HttpAdapter.class.getName() + ".publishStatusPage").equals("true");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOGGER = Logger.getLogger(HttpAdapter.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyList
    extends HttpAdapterList<HttpAdapter> {
        private DummyList() {
        }

        @Override
        protected HttpAdapter createHttpAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
            return new HttpAdapter(endpoint, this, urlPattern);
        }
    }

    private static final class Http10OutputStream
    extends ByteArrayBuffer {
        private final WSHTTPConnection con;

        Http10OutputStream(WSHTTPConnection con) {
            this.con = con;
        }

        public void close() throws IOException {
            super.close();
            this.con.setContentLengthResponseHeader(this.size());
            OutputStream os = this.con.getOutput();
            this.writeTo(os);
            os.close();
        }
    }

    final class HttpToolkit
    extends Adapter.Toolkit {
        HttpToolkit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(WSHTTPConnection con) throws IOException {
            boolean invoke = false;
            try {
                Packet packet = new Packet();
                try {
                    packet = HttpAdapter.this.decodePacket(con, this.codec);
                    invoke = true;
                }
                catch (ExceptionHasMessage e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
                    packet.setMessage(e.getFaultMessage());
                }
                catch (UnsupportedMediaException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
                    con.setStatus(415);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    con.setStatus(500);
                }
                if (invoke) {
                    try {
                        packet = this.head.process(packet, con.getWebServiceContextDelegate(), packet.transportBackChannel);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        if (!con.isClosed()) {
                            HttpAdapter.this.writeInternalServerError(con);
                        }
                        if (!con.isClosed()) {
                            con.close();
                        }
                        return;
                    }
                }
                HttpAdapter.this.encodePacket(packet, con, this.codec);
            }
            finally {
                if (!con.isClosed()) {
                    con.close();
                }
            }
        }
    }

    final class Oneway
    implements TransportBackChannel {
        WSHTTPConnection con;
        boolean closed;

        Oneway(WSHTTPConnection con) {
            this.con = con;
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                if (this.con.getStatus() == 0) {
                    this.con.setStatus(202);
                }
                try {
                    this.con.getOutput().close();
                }
                catch (IOException e) {
                    throw new WebServiceException((Throwable)e);
                }
                this.con.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AsyncTransport
    extends AbstractServerAsyncTransport<WSHTTPConnection> {
        public AsyncTransport() {
            super(HttpAdapter.this.endpoint);
        }

        public void handleAsync(WSHTTPConnection con) throws IOException {
            super.handle(con);
        }

        @Override
        protected void encodePacket(WSHTTPConnection con, @NotNull Packet packet, @NotNull Codec codec) throws IOException {
            HttpAdapter.this.encodePacket(packet, con, codec);
        }

        @Override
        @Nullable
        protected String getAcceptableMimeTypes(WSHTTPConnection con) {
            return null;
        }

        @Override
        @Nullable
        protected TransportBackChannel getTransportBackChannel(WSHTTPConnection con) {
            return new Oneway(con);
        }

        @Override
        @NotNull
        protected PropertySet getPropertySet(WSHTTPConnection con) {
            return con;
        }

        @Override
        @NotNull
        protected WebServiceContextDelegate getWebServiceContextDelegate(WSHTTPConnection con) {
            return con.getWebServiceContextDelegate();
        }
    }

    public static interface CompletionCallback {
        public void onCompletion();
    }
}

